<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientDispatchInfo extends Model
{
    use HasFactory;

    // Define the table name (optional if it's the same as the plural of the model)
    protected $table = 'client_dispatch_info';

    // Specify the primary key (optional, Laravel assumes 'id' by default)
    protected $primaryKey = 'id';

    // Specify the fillable attributes to protect against mass assignment
    protected $fillable = [
        'project_id',
        'country',
        'medium',
        'freight_terms',
        'delivery_address',
        'shipping_instructions',
        'contact_person',
        'contact_email',
        'contact_phone',
        'payment_terms',
        'customs_clearance_required',
        'customs_documentation'
    ];

    // Indicates if the model should be timestamped (created_at and updated_at)
    public $timestamps = true;  // This is default, but can be set to false if the table doesn't have timestamps

    /**
     * Relationship with the ManufacturingProject model.
     * This defines that each dispatch info belongs to a specific project.
     */
    public function project()
    {
        return $this->belongsTo(ManufacturingProject::class, 'project_id', 'id');
    }

    /**
     * Optionally, if you want to disable timestamps (if your table doesn't have `created_at` and `updated_at`)
     * public $timestamps = false;
     */

    // You can add additional methods or accessors for complex logic if needed.
}
