<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InventoryAllocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'inventory_id',
        'quantity',
        'location',
        'unit_price',
        'reorder_level'
    ];

    /**
     * Define the relationship with the Project model
     */
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    /**
     * Define the relationship with the Inventory model
     */
    public function inventory()
    {
        return $this->belongsTo(ManufacturingInventory::class);
    }
}
