<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManagerApproval extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'manager_approval_status', // approval status (0 - decline, 2 - please proceed, 3 - need review)
        'stage_id',
        'comments'
    ];

    protected $table = "manager_approval";

    // Define relationship with Stage model (SynthesisStage)
    public function stage()
    {
        return $this->belongsTo(SynthesisStage::class);
    }

    // Define relationship with Project model
    public function project()
    {
        return $this->belongsTo(ManufacturingProject::class);
    }
}
