<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManufacturingInventory extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_name',
        'stock_quantity',
        'location',
        'unit_price',
        'material_code',
        'reorder_level',
        'stock_location',
    ];

    protected $table = "inventory";

    // Check if stock is available
    public function isStockAvailable($quantity)
    {
        return $this->stock_quantity >= $quantity;
    }

    // Reduce stock after purchase
    public function reduceStock($quantity)
    {
        if ($this->isStockAvailable($quantity)) {
            $this->stock_quantity -= $quantity;
            $this->save();
            return true;
        }
        return false;
    }

    // Replenish stock if needed
    public function replenishStock($quantity)
    {
        $this->stock_quantity += $quantity;
        $this->save();
    }
}
