<?php

// app/Models/ManufacturingLead.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManufacturingLead extends Model
{
    use HasFactory;

    protected $fillable = [
        'enquiry_id',
        'lead_name',
        'lead_status',
        'estimated_cost',
    ];

    public function proposal()
    {
        return $this->hasOne(ManufacturingProposal::class);
    }

    public function enquiry()
    {
        return $this->belongsTo(ManufacturingEnquiry::class, 'enquiry_id');
    }
}
