<?php

// app/Models/ManufacturingOrder.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManufacturingOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'proposal_id',
        'client_id',
        'order_number',
        'status',
    ];

    public function project()
    {
        return $this->hasOne(ManufacturingProject::class);
    }

    public function dispatch()
    {
        return $this->hasOne(ManufacturingDispatch::class);
    }
}
