<?php
// app/Models/ManufacturingProject.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ManufacturingProject extends Model
{
    use HasFactory;

    // Define the table name if it doesn't follow Laravel's naming convention
    // protected $table = 'manufacturing_projects';

    // Fillable fields (client_id is not required anymore)
    protected $fillable = [
        'order_id',          // Existing field
        'project_name',      // New field
        'roadmap',           // Existing field
        'status',            // Existing field
        'lead_id',           // New field (required)
    ];

    // Cast 'roadmap' field as an array (assuming it's stored as JSON)
    protected $casts = [
        'roadmap' => 'array',
    ];

    /**
     * Define the relationship with the Lead model
     * Each project belongs to one lead
     */
    public function lead()
    {
        return $this->belongsTo(ManufacturingLead::class, 'lead_id');
    }

    public function inventoryAllocations()
    {
        return $this->hasMany(InventoryAllocation::class); // Assuming you have a separate inventory allocation model
    }

    // You may also add other relationships here, for example, if a project has many orders:
    // public function orders()
    // {
    //     return $this->hasMany(ManufacturingOrder::class);
    // }
}
