<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderShippingDetails extends Model
{
    use HasFactory;

    // Define the table associated with the model (optional if the table name is plural form of the model)
    protected $table = 'order_shipping_details';

    // Specify the primary key if it's not the default 'id'
    protected $primaryKey = 'id';

    // Define the fields that can be mass-assigned (fillable)
    protected $fillable = [
        'project_id',
        'dispatch_date',
        'invoice_number',
        'tracking_number',
        'dispatch_mode',
        'dispatch_status',
        'total_dispatch_weight',
        'total_dispatch_value',
        'insurance_required',
        'insurance_provider',
        'dispatch_priority',
        'estimated_delivery_date',
        'proof_of_delivery',
        'dispatch_method',
        'port_of_origin',
        'port_of_destination',
        'dispatch_notes',
    ];

    // Define the fields that should not be mass-assigned (guarded)
    protected $guarded = [
        'id', // Typically, you want to guard the primary key
        'created_at',
        'updated_at',
    ];

    // Set the date format if needed (Laravel uses Y-m-d by default for dates)
    protected $dates = ['dispatch_date', 'estimated_delivery_date', 'created_at', 'updated_at'];

    // Automatically handle timestamps (created_at and updated_at)
    public $timestamps = true;

    /**
     * Get the project that owns the shipping detail.
     */
    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
}
