<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'quantity',
        'status', // (pending, approved, completed)
        'approved_by',
    ];

    public function inventory()
    {
        return $this->belongsTo(ManufacturingInventory::class);
    }
}
