<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SynthesisStage extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'stage_name',
        'batch_number',
        'progress',
        'reaction',
        'scale',
        'experimental_conditions',
        'results',
        'yield',
        'data',
        'molecule_structure'
    ];

    public function project()
    {
        return $this->belongsTo(ManufacturingProject::class);
    }

    public function comments()
    {
        return $this->hasMany(StageComment::class);
    }

    public function approval()
    {
        return $this->hasOne(ManagerApproval::class);
    }
    public function managerApprovals()
    {
        return $this->hasMany(ManagerApproval::class);
    }
}
