<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_manufacturing_leads_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManufacturingLeadsTable extends Migration
{
    public function up()
    {
        Schema::create('manufacturing_leads', function (Blueprint $table) {
            $table->id();
            // $table->foreignId('enquiry_id')->constrained('manufacturing_enquiries')->onDelete('cascade');
            $table->unsignedBigInteger('enquiry_id'); // Assuming this is a foreign key from the `enquiries` table
            $table->string('lead_name');
            $table->string('lead_status');
            $table->decimal('estimated_cost', 10, 2);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('manufacturing_leads');
    }
}
