<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_manufacturing_projects_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManufacturingProjectsTable extends Migration
{
    public function up()
    {
        Schema::create('manufacturing_projects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained('manufacturing_orders')->onDelete('cascade');
            $table->string('project_name');
            $table->json('roadmap'); // Store project stages in JSON format
            $table->enum('status', ['Not Started', 'In Progress', 'Completed'])->default('Not Started');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('manufacturing_projects');
    }
}
