<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_manufacturing_inventory_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManufacturingInventoryTable extends Migration
{
    public function up()
    {
        Schema::create('manufacturing_inventory', function (Blueprint $table) {
            $table->id();
            $table->string('material_name');
            $table->string('material_code');
            $table->decimal('quantity_in_stock', 10, 2);
            $table->decimal('reorder_level', 10, 2);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('manufacturing_inventory');
    }
}
