<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_manufacturing_synthesis_stages_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManufacturingSynthesisStagesTable extends Migration
{
    public function up()
    {
        Schema::create('manufacturing_synthesis_stages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained('manufacturing_projects')->onDelete('cascade');
            $table->string('stage_name');
            $table->string('batch_number');
            $table->text('comments');
            $table->enum('status', ['In Progress', 'Completed'])->default('In Progress');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('manufacturing_synthesis_stages');
    }
}
