<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_manufacturing_dispatches_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateManufacturingDispatchesTable extends Migration
{
    public function up()
    {
        Schema::create('manufacturing_dispatches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained('manufacturing_orders')->onDelete('cascade');
            $table->enum('dispatch_type', ['Domestic', 'Export']);
            $table->string('tracking_number')->nullable();
            $table->string('shipping_method'); // e.g., FOB, CIF
            $table->string('destination_country');
            $table->decimal('dispatch_cost', 10, 2);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('manufacturing_dispatches');
    }
}
