@extends('layouts.app')

@push('datatable-styles')
@include('sections.datatable_css')
@endpush
<!-- jQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<!-- Select2 CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<!-- Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<!-- Custom CSS -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<style>
    .ticket.active {
        background-color: #f0f0f0;
        border-color: #bbb;
    }

    .tab-content {
        display: none;
        /* Hide content by default */
        padding: 15px;
        border: 1px solid #ddd;
        margin-top: 10px;
        border-top: none;
    }

    .stage-item {
        padding: 20px;
        /* background-color: #42a3b9; */
        margin-bottom: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        font-size: 14px;
    }

    .stage-item .stage-header {
        margin-bottom: 10px;
    }

    .stage-name {
        font-size: 18px;
        font-weight: bold;
        color: #333;
    }

    .stage-progress {
        font-size: 14px;
        color: #666;
    }

    .stage-comments {
        margin-top: 10px;
        margin-bottom: 15px;
    }

    .stage-comments p {
        font-size: 14px;
        color: #333;
    }

    .approval-action {
        margin-bottom: 20px;
    }

    .approval-label {
        font-weight: bold;
        margin-bottom: 5px;
        font-size: 14px;
        display: block;
    }

    .select {
        width: 100%;
        margin-bottom: 10px;
    }

    .approval-dropdown {
        font-size: 14px;
        padding: 8px;
        width: 100%;
        border-radius: 6px;
        border: 1px solid #ccc;
    }

    .approval-dropdown:focus {
        border-color: #007bff;
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
    }

    .approval-comments {
        margin-bottom: 15px;
    }

    .comment-label {
        font-weight: bold;
        font-size: 14px;
    }

    .approval-textarea {
        width: 100%;
        height: 100px;
        font-size: 14px;
        padding: 10px;
        border-radius: 6px;
        border: 1px solid #ccc;
    }

    .approval-textarea:focus {
        border-color: #007bff;
        box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
    }

    .action-buttons {
        display: flex;
        gap: 10px;
        justify-content: space-between;
    }

    .action-buttons .btn {
        padding: 8px 16px;
        font-size: 14px;
        width: 32%;
        border-radius: 6px;
    }

    .btn-success {
        background-color: #28a745;
        border: none;
    }

    .btn-success:hover {
        background-color: #218838;
    }

    .btn-danger {
        background-color: #dc3545;
        border: none;
    }

    .btn-danger:hover {
        background-color: #c82333;
    }

    .btn-warning {
        background-color: #ffc107;
        border: none;
    }

    .btn-warning:hover {
        background-color: #e0a800;
    }

    .notification-box {
        border-left: 5px solid #007bff;
        background-color: #d1ecf1;
        color: #0c5460;
    }
</style>
@section('filter-section')
<!-- DASHBOARD HEADER START -->
<div class="d-flex filter-box project-header bg-white dashboard-header">

    <div class="mobile-close-overlay w-100 h-100" id="close-client-overlay"></div>
    <!-- HTML Code for Tabs -->
    <div class="project-menu d-lg-flex" id="mob-client-detail">

        <a class="d-none close-it" href="javascript:;" id="close-client-detail">
            <i class="fa fa-times"></i>
        </a>
        <!-- Completed Synthesis Tab -->
        <x-tab :text="__('Completed Synthesis')" class="ticket" ajax="false" id="completed-synthesis-tab" data-target="#completed-synthesis-content" href="#" />

        <!-- Request for Next Step Synthesis Tab -->
        <x-tab :text="__('Request for Next Step Synthesis')" class="ticket" ajax="false" id="request-next-step-synthesis-tab" data-target="#request-next-step-synthesis-content" href="#" />


    </div>


    <div class="ml-auto d-flex align-items-center justify-content-center ">

        <!-- DATE START -->
        <div
            class="{{ request('tab') == 'overview' || request('tab') == '' ? 'd-none' : 'd-flex' }} align-items-center border-left-grey border-left-grey-sm-0 h-100 pl-4">
            <i class="fa fa-calendar-alt mr-2 f-14 text-dark-grey"></i>
            <div class="select-status">
                <input type="text"
                    class="position-relative text-dark form-control border-0 p-2 text-left f-14 f-w-500 border-additional-grey"
                    id="datatableRange2" placeholder="@lang('placeholders.dateRange')">
            </div>
        </div>
        <!-- DATE END -->
        @if (isset($widgets) && in_array('admin', user_roles()))
        <div class="admin-dash-settings">
            <x-form id="dashboardWidgetForm" method="POST">
                <div class="dropdown keep-open">
                    <a class="d-flex align-items-center justify-content-center dropdown-toggle px-lg-4 border-left-grey text-dark"
                        type="link" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true"
                        aria-expanded="false">
                        <i class="fa fa-cog" data-original-title="{{__('modules.dashboard.dashboardWidgetsSettings')}}" data-toggle="tooltip"></i>
                    </a>
                    <!-- Dropdown - User Information -->
                    <ul class="dropdown-menu dropdown-menu-right dashboard-settings p-20"
                        aria-labelledby="dropdownMenuLink" tabindex="0">
                        <li class="border-bottom mb-3">
                            <h4 class="heading-h3">@lang('modules.dashboard.dashboardWidgets')</h4>
                        </li>
                        @foreach ($widgets as $widget)
                        @php
                        $wname = \Illuminate\Support\Str::camel($widget->widget_name);
                        @endphp
                        <li class="mb-2 float-left w-50">
                            <div class="checkbox checkbox-info ">
                                <input id="{{ $widget->widget_name }}" name="{{ $widget->widget_name }}"
                                    value="true" @if ($widget->status) checked @endif type="checkbox">
                                <label for="{{ $widget->widget_name }}">@lang('modules.dashboard.' .
                                    $wname)</label>
                            </div>
                        </li>
                        @endforeach
                        @if (count($widgets) % 2 != 0)
                        <li class="mb-2 float-left w-50 height-35"></li>
                        @endif
                        <li class="float-none w-100">
                            <x-forms.button-primary id="save-dashboard-widget" icon="check">@lang('app.save')
                            </x-forms.button-primary>
                        </li>
                    </ul>
                </div>
            </x-form>
        </div>
        @endif

    </div>

    <a class="mb-0 d-block d-lg-none text-dark-grey mr-2 border-left-grey border-bottom-0"
        onclick="openClientDetailSidebar()"><i class="fa fa-ellipsis-v"></i></a>

</div>
<!-- FILTER END -->


@endsection

@section('content')
<!-- Add Task Export Buttons End -->
<div id="completed-synthesis-content" class="tab-content" style="display: none;">
    <table id="completedSynthesisTable" class="display">
        <thead>
            <tr>
                <th>Project Name</th>
                <th>Project Status</th>
                <th>Allocation Status</th>
                <th>Inventory Quantity</th>
                <th>Location</th>
                <th>Unit Price</th>
                <th>Stage Name</th>
                <th>Batch Number</th>
                <th>Progress</th>
                <!-- <th>Action</th> -->
            </tr>
        </thead>
        <tbody>
            <!-- Data will be populated by DataTable -->
        </tbody>
    </table>
</div>

<!-- Request for Next Step Synthesis Content -->
<div id="request-next-step-synthesis-content" class="tab-content" style="display: none;">
    <table id="projectsTable" class="display" style="width: 100%;">
        <thead>
            <tr>
                <th>Project ID</th>
                <th>Project Name</th>
                <th>Stages</th>
                <th>Approval Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <!-- Data will be populated by DataTable -->
        </tbody>
    </table>
    <div class="modal fade" id="stagesModal" tabindex="-1" role="dialog" aria-labelledby="stagesModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width:360mm; padding: 20px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="stagesModalLabel">Synthesis Stage Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="stagesModalBody">
                    <!-- Stage details will be populated here -->
                </div>
            </div>
        </div>
    </div>


</div>

@endsection

@push('scripts')
@include('sections.datatable_js')
<!-- Bootstrap Select JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.1/dist/js/bootstrap-select.min.js"></script>

<!-- Date Range Picker JS -->
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get all the tab links (tabs with class "ticket")
        const tabs = document.querySelectorAll('.ticket');

        // Get all the tab contents (divs with class "tab-content")
        const tabContents = document.querySelectorAll('.tab-content');

        // Add click event listeners to each tab link
        tabs.forEach(tab => {
            tab.addEventListener('click', function(event) {
                event.preventDefault(); // Prevent default behavior for anchor tag

                // Hide all tab contents
                tabContents.forEach(content => content.style.display = 'none');

                // Remove "active" class from all tabs (if any)
                tabs.forEach(tab => tab.classList.remove('active'));

                // Show the corresponding tab content based on the clicked tab
                const targetContent = document.querySelector(tab.getAttribute('data-target'));
                targetContent.style.display = 'block';

                // Add "active" class to the clicked tab for visual feedback
                tab.classList.add('active');
            });
        });

        // Optionally, trigger the first tab to be clicked by default (if needed)
        document.getElementById('completed-synthesis-tab').click();
    });

    $(document).ready(function() {
        var table = $('#projectsTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '/account/get_project_details_for_manager', // Your route to fetch data
                type: 'GET',
                data: function(d) {
                    // Any additional parameters you want to send (e.g., filters)
                    d.status = 'Allocated'; // Optional filter example 
                }
            },
            columns: [{
                    data: 'project_id'
                },
                {
                    data: 'project_name'
                },
                {
                    data: 'stage_names'
                },
                {
                    data: 'manager_approval_status',
                    render: function(data, type, row) {
                        console.log('manager_approval_status:', data); // Log the actual value of `data`

                        // Ensure the data is treated as a number or integer
                        data = Number(data); // Convert to number just in case it is coming as a string

                        let badgeClass = '';
                        let statusText = '';

                        // Check the value of `data` (manager_approval_status)
                        switch (data) {
                            case 0:
                                badgeClass = 'badge-danger'; // Red badge for Reject
                                statusText = 'Rejected';
                                break;
                            case 1:
                                badgeClass = 'badge-success'; // Green badge for Approved
                                statusText = 'Approved';
                                break;
                            case 2:
                                badgeClass = 'badge-warning'; // Yellow badge for Waiting for Next Steps
                                statusText = 'Awaiting Approval for Next Steps';
                                break;
                            case 3:
                                badgeClass = 'badge-info'; // Blue badge for Approved for Next Steps
                                statusText = 'Approved for Next Steps';
                                break;
                            default:
                                badgeClass = 'badge-secondary'; // Default badge for Pending/Unknown status
                                statusText = 'Pending';
                        }

                        // Return the badge with the correct class and status text
                        return `<span class="badge ${badgeClass}">${statusText}</span>`;
                    }

                },

                {
                    data: null,
                    render: function(data, type, row) {
                        return `
            <button class="viewStagesBtn btn btn-primary btn-sm p-1" data-project-id="${row.project_id}">
                <i class="fa fa-eye"></i> View Stages
            </button>
        `;
                    }
                }

            ],
            drawCallback: function(settings) {
                // Get the recordsTotal count from the settings object
                var recordCount = settings.json.recordsTotal;
            }
        });

        // Handle click event to view stages for approval
        $(document).on('click', '.viewStagesBtn', function() {
            var projectId = $(this).data('project-id');
            viewStagesToApprove(projectId);
        });
    });

    function viewStagesToApprove(projectId) {

        // Fetch synthesis stages for the selected project
        $.ajax({
            url: `/account/get_synthesis_stages_by_project/${projectId}`,
            method: 'GET',
            success: function(response) {
                var stagesHtml = '';
                var modalHtml = '';

                response.stages.forEach(function(stage) {
                    stagesHtml += `
        <div class="stage" style="margin-bottom: 20px;">
            <table class="table table-bordered" style="width: 100%; table-layout: fixed; border-collapse: collapse; font-size: 12px; margin-bottom: 15px;">
                <thead>
                    <tr style="background-color: #f8f9fa; text-align: center;">
                        <th style="padding: 8px;">Stage Name</th>
                        <th style="padding: 8px;">Batch Number</th>
                        <th style="padding: 8px;">Progress</th>
                        <th style="padding: 8px;">Reaction</th>
                        <th style="padding: 8px;">Scale</th>
                        <th style="padding: 8px;">Experimental Conditions</th>
                        <th style="padding: 8px;">Results</th>
                        <th style="padding: 8px;">Yield</th>
                        <th style="padding: 8px;">Data</th>
                        <th style="padding: 8px;">Comment</th>
                        <th style="padding: 8px;">Manager Approval</th>
                        <th style="padding: 8px;">Approval Comments</th>
                    </tr>
                </thead>
                <tbody>
                    <tr style="text-align: center;">
                        <td style="padding: 8px;">${stage.stage_name}</td>
                        <td style="padding: 8px;">${stage.batch_number}</td>
                        <td style="padding: 8px;">${stage.progress}%</td>
                        <td style="padding: 8px;">${stage.reaction || 'No reaction provided'}</td>
                        <td style="padding: 8px;">${stage.scale || 'Not specified'}</td>
                        <td style="padding: 8px;">${stage.experimental_conditions || 'No conditions specified'}</td>
                        <td style="padding: 8px;">${stage.results || 'No results provided'}</td>
                        <td style="padding: 8px;">${stage.yield || 'No yield data'}</td>
                        <td style="padding: 8px;">${stage.data || 'No data provided'}</td>
                        <td style="padding: 8px;">${stage.comment || 'No comments'}</td>
                        <td style="padding: 8px;">${stage.approved ? 'Approved' : 'Not Approved'}</td>
                        <td style="padding: 8px;">${stage.approval_comments || 'No comments'}</td>
                         
                    </tr>
                </tbody>
            </table>
        </div>
        <hr style="border-top: 1px solid #ccc;">
    `;
                    if (stage.stage_name === 'T3') {
                        // Append the dropdown for T3
                        stagesHtml += `
    <div class="stage-item" data-stage-id="${projectId}">
        <!-- Notification box for Manager -->
        <div class="row">
        <div class="col-lg-6">
        <div class="notification-box bg-info text-white p-3 mb-3 rounded">
            <strong>Attention Manager:</strong> Please review the following stage and take action.
        </div>
        </div>
         <div class="col-lg-6" style="padding: 20px;
    background-color: #e3e3e3;
    margin-bottom: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    font-size: 14px;">
        <!-- Approval dropdown for T3 stage -->
        <div class="approval-action">
            <label for="approval-dropdown-${projectId}" class="approval-label">Select Action</label>
            <select class="form-control approval-dropdown height-35 f-14" id="approval-dropdown-${projectId}" data-stage-id="${projectId}">
                <option value="">Select Action</option>
                <option value="3" class="approve-option">Approve for Next Steps</option>
                <option value="0" class="reject-option">Reject</option>
            </select>
        </div>

        <!-- Comment box for manager's additional comments -->
        <div class="approval-comments">
            <label for="approval-comment-${projectId}" class="comment-label">Approval Comments</label>
            <textarea id="approval-comment-${projectId}" class="form-control approval-textarea" placeholder="Add your comments here..."></textarea>
        </div>

        <!-- Action buttons -->
        <div class="action-buttons text-right">
            <button type="button" class="btn btn-success approve-btn approveBtn" data-stage-id="${projectId}" style="display: none;">Approve</button>
            <button type="button" class="btn btn-danger reject-btn rejectBtn" data-stage-id="${projectId}" style="display: none;">Reject</button>
        </div>
        </div>
        </div>
    </div>
    `;
                    }


                });

                $('#stagesModalBody').html(stagesHtml);
                // Show the modal
                $('#stagesModal').modal('show');
            }
        });
    }

    $(document).on('change', '.approval-dropdown', function() {
        var stageId = $(this).data('stage-id');
        var action = $(this).val();

        $(this).closest('.stage-item').find('.action-buttons .btn').hide();

        if (action == 3) {
            $(this).closest('.stage-item').find('.approve-btn').show();
        } else if (action == 0) {
            $(this).closest('.stage-item').find('.reject-btn').show();
        }
    });

    $(document).on('click', '.approveBtn, .rejectBtn', function() {
        var projectId = $(this).data('stage-id');
        var action = $(this).closest('.stage-item').find('.approval-dropdown').val();
        var comment = $(this).closest('.stage-item').find('.approval-textarea').val();

        if (!action) {
            alert('Please select an action (Approve or Reject).');
            return;
        }

        if (!comment) {
            alert('Please add your comments.');
            return;
        }

        $.ajax({
            url: '/account/submitApproval',
            type: 'POST',
            data: {
                projectId: projectId,
                action: action,
                comment: comment,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    $('#stagesModal').modal('hide');
                    $('#projectsTable').DataTable().ajax.reload();
                    alert('Approval status updated successfully.');
                } else {
                    alert('An error occurred while updating the approval status.');
                }
            },
            error: function(xhr, status, error) {
                alert('Error submitting the approval: ' + error);
            }
        });

    });


    $(document).ready(function() {
        if ($.fn.dataTable.isDataTable('#completedSynthesisTable')) {
            // Destroy the existing DataTable instance
            readyTodispatchtable.clear().destroy();
        }

        var readyTodispatchtable = $('#completedSynthesisTable').DataTable({
            processing: true,
            serverSide: false,
            ajax: {
                url: '/account/project_ready_to_dispatch', // URL to fetch data
                type: 'GET',
                dataSrc: function(json) {
                    console.log(json); // Log for debugging

                    if (!json.data || !json.data.length) {
                        return [];
                    }

                    var processedData = json.data.map(function(row) {
                        return {
                            project_name: row.project_name,
                            project_status: row.project_status,
                            allocation_status: row.allocation_status,
                            quantity: row.total_allocated,
                            location: row.location || 'N/A',
                            unit_price: row.unit_price || 'N/A',
                            stage_name: row.stage_names,
                            batch_number: row.batch_numbers,
                            progress: row.progresses,
                            project_id: row.project_id,
                            stage_id: row.stage_ids,
                            dispatch_status: row.dispatch_status,
                            stage_comments: row.stage_comments || 'N/A',
                            approval_statuses: row.approval_statuses || 'N/A',
                            approval_comments: row.approval_comments || 'N/A'
                        };
                    });

                    return processedData;
                }
            },
            columns: [{
                    data: 'project_name'
                },
                {
                    data: 'project_status'
                },
                {
                    data: 'allocation_status'
                },
                {
                    data: 'quantity'
                },
                {
                    data: 'location'
                },
                {
                    data: 'unit_price'
                },
                {
                    data: 'stage_name',
                    render: function(data) {
                        return `<span class="badge badge-info">${data}</span>`;
                    }
                },
                {
                    data: 'batch_number'
                },
                {
                    data: 'progress',
                    render: function(data) {
                        return `<span class="badge badge-success">${data}%</span>`;
                    }
                }
            ],
            columnDefs: [{
                    targets: 0,
                    width: "150px"
                }, // Project Name
                {
                    targets: 1,
                    width: "150px"
                }, // Project Status
                {
                    targets: 2,
                    width: "180px"
                }, // Allocation Status
                {
                    targets: 3,
                    width: "130px"
                }, // Quantity
                {
                    targets: 4,
                    width: "150px"
                }, // Location
                {
                    targets: 5,
                    width: "120px"
                }, // Unit Price
                {
                    targets: 6,
                    width: "150px"
                }, // Stage Name (badge)
                {
                    targets: 7,
                    width: "120px"
                }, // Batch Number
                {
                    targets: 8,
                    width: "130px"
                }, // Progress (badge)

            ],
            scrollX: true,
            scrollY: '400px',
            paging: true,
            lengthChange: true,
            searching: true,
        });

    });
</script>


@endpush