<?php $__env->startPush('datatable-styles'); ?>
<?php echo $__env->make('sections.datatable_css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<!-- jQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<!-- Select2 CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>


<!-- Custom CSS -->
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<style>
    /* Table custom styling */
    #enquiriesTable {
        width: 100%;
        margin-top: 20px;
        border-collapse: collapse;
    }

    /* Styling table header */
    #enquiriesTable thead {
        background-color: #343a40;
        color: #fff;
    }

    /* Style rows with hover effect */
    #enquiriesTable tbody tr:hover {
        background-color: #f1f1f1;
        cursor: pointer;
    }

    /* Style table cells */
    #enquiriesTable td,
    #enquiriesTable th {
        text-align: center;
        padding: 12px;
        font-size: 14px;
    }

    /* Badge styling for Status */
    .badge {
        padding: 6px 12px;
        font-size: 13px;
    }

    .badge-success {
        background-color: #28a745;
    }

    .badge-danger {
        background-color: #dc3545;
    }

    /* Button styling */
    .btn {
        padding: 6px 12px;
        font-size: 14px;
        border-radius: 3px;
    }

    .btn-primary {
        background-color: #007bff;
        border: none;
    }

    .btn-danger {
        background-color: #dc3545;
        border: none;
    }

    .btn-sm {
        padding: 4px 8px;
    }

    /* Responsiveness for smaller screens */
    @media (max-width: 768px) {
        #enquiriesTable {
            font-size: 12px;
        }

        #enquiriesTable td,
        #enquiriesTable th {
            padding: 8px;
        }
    }

    .badge-primary {
        background-color: #007bff;
        /* Change this to any color you want for the approval status */
    }

    /* Styling for the tab navigation */
    .nav-tabs .nav-item .nav-link {
        padding: 10px 15px;
        font-weight: bold;
    }

    .nav-tabs .nav-item .nav-link.active {
        background-color: #007bff;
        /* Custom active tab color */
        color: #fff;
    }

    /* Custom table styles */
    .table th,
    .table td {
        text-align: center;
        vertical-align: middle;
    }

    /* Add some space around the table */
    .table {
        margin-top: 20px;
    }

    /* Optional: Styling for Action Buttons */
    .table .btn {
        margin: 0 5px;
    }

    /* Ensure the message area is properly styled */
    #message {
        background-color: #dff0d8;
        color: #3c763d;
        padding: 10px;
        margin-bottom: 15px;
        border: 1px solid #d6e9c6;
        border-radius: 5px;
    }

    /* Basic table styling */
    .table {
        width: 100%;
        margin: 20px 0;
        border-collapse: collapse;
        border-spacing: 0;
        background-color: #fff;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .table th,
    .table td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #f1f1f1;
    }

    .table th {
        background-color: #f7f7f7;
        color: #333;
        font-weight: bold;
        font-size: 14px;
        text-transform: uppercase;
    }

    .table td {
        font-size: 13px;
        color: #555;
    }

    .table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .table tr:hover {
        background-color: #f1f1f1;
    }

    .table .badge {
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 12px;
        text-transform: capitalize;
    }

    .table .btn {
        font-size: 14px;
        padding: 6px 12px;
        margin: 0 5px;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .table .btn-info {
        background-color: #17a2b8;
        color: #fff;
    }

    .table .btn-warning {
        background-color: #ffc107;
        color: #fff;
    }

    .table .btn-danger {
        background-color: #dc3545;
        color: #fff;
    }

    .table .btn-info:hover,
    .table .btn-warning:hover,
    .table .btn-danger:hover {
        opacity: 0.8;
    }

    /* Styling the empty data message */
    #message {
        display: none;
        margin: 20px 0;
        padding: 10px;
        background-color: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
        border-radius: 4px;
        text-align: center;
    }

    /* Responsive Table */
    @media (max-width: 768px) {

        .table th,
        .table td {
            padding: 8px 10px;
            font-size: 12px;
        }
    }

    /* Table wrapper */
    .table-wrapper {
        overflow-x: auto;
        margin-top: 20px;
    }

    /* For table when data is empty */
    .table.empty-table {
        text-align: center;
    }

    .table.empty-table td {
        background-color: #f9f9f9;
        color: #888;
        font-style: italic;
    }

    /* Styling for table actions and buttons */
    .table-actions {
        display: flex;
        justify-content: flex-end;
        margin-bottom: 10px;
    }

    .table-actions .btn {
        margin-left: 10px;
    }

    /* Success Badge (For Approved items) */
    .badge-success {
        background-color: #28a745;
        color: #fff;
    }

    /* Info Badge (For Pending items) */
    .badge-info {
        background-color: #17a2b8;
        color: #fff;
    }

    /* Warning Badge (For Under Purchase) */
    .badge-warning {
        background-color: #ffc107;
        color: #fff;
    }

    /* Primary Badge (For Waiting for Approval) */
    .badge-primary {
        background-color: #007bff;
        color: #fff;
    }

    .badge-secondary {
        background-color: #6c757d;
        color: #fff;
    }

    /* Style for rows with low stock (below 100) */
    .low-stock {
        background-color: #f8d7da;
        /* Light red background */
        color: #721c24;
        /* Dark red text */
    }

    /* Style for the Purchase button */
    .purchase-btn {
        background-color: #ffc107;
        /* Yellow background */
        color: #fff;
        border: none;
        padding: 6px 12px;
        cursor: pointer;
        font-size: 14px;
        border-radius: 4px;
    }

    .purchase-btn:hover {
        opacity: 0.8;
    }

    /* Customizing the tooltip appearance */
    .tooltip-inner {
        background-color: #333;
        /* Dark background */
        color: white;
        /* White text */
        font-size: 12px;
        /* Smaller font size */
        border-radius: 4px;
        /* Rounded corners */
    }

    .tooltip.bs-tooltip-top .arrow::before {
        border-top-color: #333;
        /* Dark arrow */
    }

    .tooltip.bs-tooltip-bottom .arrow::before {
        border-bottom-color: #333;
        /* Dark arrow */
    }

    /* Custom CSS for gap between buttons */
    .btn-group .btn {
        margin-right: 8px;
        /* Adjust this value for desired gap */
    }

    /* Optional: If you want to remove the gap from the last button */
    .btn-group .btn:last-child {
        margin-right: 0;
    }
</style>
<?php $__env->startSection('filter-section'); ?>
<!-- DASHBOARD HEADER START -->
<div class="d-flex filter-box project-header bg-white dashboard-header">

    <div class="mobile-close-overlay w-100 h-100" id="close-client-overlay"></div>
    <div class="project-menu d-lg-flex" id="mob-client-detail">

        <a class="d-none close-it" href="javascript:;" id="close-client-detail">
            <i class="fa fa-times"></i>
        </a>


        <!-- Enquiry Tab -->
        <!-- <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Enquiry'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'overview','id' => 'enquiry-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?> -->

        <!-- Lead Tab -->
        <!-- <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Lead'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'project','id' => 'lead-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?> -->

        <!-- Proposal Tab -->
        <!-- <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Proposal'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'client','id' => 'proposal-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?> -->

        <!-- Project Tab -->
        <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Project'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'hr','id' => 'project-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>

        <!-- Inventory Tab -->
        <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Inventory'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'ticket','id' => 'inventory-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
        <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Synthesis'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'ticket','id' => 'synthesis-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>

        <!-- Dispatch Tab -->
        <?php if (isset($component)) { $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab = $attributes; } ?>
<?php $component = App\View\Components\Tab::resolve(['text' => __('Dispatch'),'ajax' => 'false','href' => '#'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tab'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Tab::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'finance','id' => 'dispatch-tab']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $attributes = $__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__attributesOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab)): ?>
<?php $component = $__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab; ?>
<?php unset($__componentOriginal4b0c45ee1a38bb46a01c2a25edd749ab); ?>
<?php endif; ?>


    </div>


    <div class="ml-auto d-flex align-items-center justify-content-center ">

        <!-- DATE START -->
        <div
            class="<?php echo e(request('tab') == 'overview' || request('tab') == '' ? 'd-none' : 'd-flex'); ?> align-items-center border-left-grey border-left-grey-sm-0 h-100 pl-4">
            <i class="fa fa-calendar-alt mr-2 f-14 text-dark-grey"></i>
            <div class="select-status">
                <input type="text"
                    class="position-relative text-dark form-control border-0 p-2 text-left f-14 f-w-500 border-additional-grey"
                    id="datatableRange2" placeholder="<?php echo app('translator')->get('placeholders.dateRange'); ?>">
            </div>
        </div>
        <!-- DATE END -->
        <?php if(isset($widgets) && in_array('admin', user_roles())): ?>
        <div class="admin-dash-settings">
            <?php if (isset($component)) { $__componentOriginal18ad2e0d264f9740dc73fff715357c28 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal18ad2e0d264f9740dc73fff715357c28 = $attributes; } ?>
<?php $component = App\View\Components\Form::resolve(['method' => 'POST'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'dashboardWidgetForm']); ?>
                <div class="dropdown keep-open">
                    <a class="d-flex align-items-center justify-content-center dropdown-toggle px-lg-4 border-left-grey text-dark"
                        type="link" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true"
                        aria-expanded="false">
                        <i class="fa fa-cog" data-original-title="<?php echo e(__('modules.dashboard.dashboardWidgetsSettings')); ?>" data-toggle="tooltip"></i>
                    </a>
                    <!-- Dropdown - User Information -->
                    <ul class="dropdown-menu dropdown-menu-right dashboard-settings p-20"
                        aria-labelledby="dropdownMenuLink" tabindex="0">
                        <li class="border-bottom mb-3">
                            <h4 class="heading-h3"><?php echo app('translator')->get('modules.dashboard.dashboardWidgets'); ?></h4>
                        </li>
                        <?php $__currentLoopData = $widgets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $widget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $wname = \Illuminate\Support\Str::camel($widget->widget_name);
                        ?>
                        <li class="mb-2 float-left w-50">
                            <div class="checkbox checkbox-info ">
                                <input id="<?php echo e($widget->widget_name); ?>" name="<?php echo e($widget->widget_name); ?>"
                                    value="true" <?php if($widget->status): ?> checked <?php endif; ?> type="checkbox">
                                <label for="<?php echo e($widget->widget_name); ?>"><?php echo app('translator')->get('modules.dashboard.' .
                                    $wname); ?></label>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if(count($widgets) % 2 != 0): ?>
                        <li class="mb-2 float-left w-50 height-35"></li>
                        <?php endif; ?>
                        <li class="float-none w-100">
                            <?php if (isset($component)) { $__componentOriginalcf8d12533ff890e0d6573daf32b7618d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf8d12533ff890e0d6573daf32b7618d = $attributes; } ?>
<?php $component = App\View\Components\Forms\ButtonPrimary::resolve(['icon' => 'check'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('forms.button-primary'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Forms\ButtonPrimary::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'save-dashboard-widget']); ?><?php echo app('translator')->get('app.save'); ?>
                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf8d12533ff890e0d6573daf32b7618d)): ?>
<?php $attributes = $__attributesOriginalcf8d12533ff890e0d6573daf32b7618d; ?>
<?php unset($__attributesOriginalcf8d12533ff890e0d6573daf32b7618d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf8d12533ff890e0d6573daf32b7618d)): ?>
<?php $component = $__componentOriginalcf8d12533ff890e0d6573daf32b7618d; ?>
<?php unset($__componentOriginalcf8d12533ff890e0d6573daf32b7618d); ?>
<?php endif; ?>
                        </li>
                    </ul>
                </div>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal18ad2e0d264f9740dc73fff715357c28)): ?>
<?php $attributes = $__attributesOriginal18ad2e0d264f9740dc73fff715357c28; ?>
<?php unset($__attributesOriginal18ad2e0d264f9740dc73fff715357c28); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal18ad2e0d264f9740dc73fff715357c28)): ?>
<?php $component = $__componentOriginal18ad2e0d264f9740dc73fff715357c28; ?>
<?php unset($__componentOriginal18ad2e0d264f9740dc73fff715357c28); ?>
<?php endif; ?>
        </div>
        <?php endif; ?>

    </div>

    <a class="mb-0 d-block d-lg-none text-dark-grey mr-2 border-left-grey border-bottom-0"
        onclick="openClientDetailSidebar()"><i class="fa fa-ellipsis-v"></i></a>

</div>
<!-- FILTER END -->


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Add Task Export Buttons End -->
<div id="enquiry-tab-content" class="tab-content">
    <div class="content-wrapper">
        <div class="d-flex justify-content-between align-items-center action-bar">
            <!-- Button Group for Add New Enquiry -->
            <div class="btn-group mt-2 mt-lg-0 mt-md-0 ml-0" role="group">
                <button class="btn btn-success" id="addEnquiryBtn"><i class="fas fa-plus mr-2"></i> </button>
            </div>

            <!-- Filter Fields Section -->
            <div class="d-flex align-items-center filter-section">
                <input type="text" class="form-control height-35 f-6 mr-2" id="client_name_filter" placeholder="Filter by Client Name">
                <input type="text" class="form-control height-35 f-6 mr-2" id="project_name_filter" placeholder="Filter by Project Name">
                <select id="status_filter" class="form-control select-picker mr-2">
                    <option value="">Select Status</option>
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                </select>
                <input type="date" id="start_date_filter" class="form-control height-35 f-6 mr-2">
                <input type="date" id="end_date_filter" class="form-control height-35 f-6 mr-2">
                <button class="btn btn-primary" id="applyFiltersBtn"><i class="fas fa-filter mr-2"></i></button>
            </div>
        </div>

        <table id="enquiriesTable" class="display">
            <thead>
                <tr>

                    <th>Client ID</th>
                    <th>Client Name</th>
                    <th>Project Name</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Updated At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be appended here via AJAX -->
            </tbody>
        </table>
    </div>

    <!-- Modal for Add Enquiry -->
    <div class="modal" id="addEnquiryModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Enquiry</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addEnquiryForm" method="POST">
                        <div class="form-group">
                            <label for="client_name">Client Name</label>
                            <input type="text" class="form-control height-35 f-14" id="client_name" name="client_name" required>
                        </div>
                        <div class="form-group">
                            <label for="project_name">Project Name</label>
                            <input type="text" class="form-control height-35 f-14" id="project_name" name="project_name" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control f-14 pt-2" id="description" name="description" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control select-picker" id="status" name="status" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Save Enquiry</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Edit Enquiry Modal -->
    <!-- Modal for editing enquiry -->
    <div class="modal" id="editEnquiryModal" tabindex="-1" role="dialog" style="display: none;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Enquiry</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editEnquiryForm" method="POST">
                        <!-- Form fields to populate dynamically -->
                        <div class="form-group">
                            <label for="client_name_val">Client Name</label>
                            <input type="text" class="form-control height-35 f-14" id="client_name_val" name="client_name" required>
                        </div>
                        <div class="form-group">
                            <label for="project_name_val">Project Name</label>
                            <input type="text" class="form-control height-35 f-14" id="project_name_val" name="project_name" required>
                        </div>
                        <div class="form-group">
                            <label for="description_val">Description</label>
                            <textarea class="form-control f-14 pt-2" id="description_val" name="description" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="status_val">Status</label>
                            <select class="form-control select-picker" id="status_val" name="status" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                        <input type="hidden" id="enquiry_id_val" name="enquiry_id"> <!-- Hidden field for enquiry ID -->
                        <button type="submit" class="btn btn-primary">Update Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Lead Implimentation Goes here........ -->
<div id="lead-tab-content" class="tab-content">
    <div class="content-wrapper">
        <div class="d-flex justify-content-between align-items-center action-bar">
            <!-- Button Group for Add New Enquiry -->
            <div class="btn-group mt-2 mt-lg-0 mt-md-0 ml-0" role="group">
                <!-- Add New Lead Button -->
                <button class="btn btn-success" id="addLeadBtn"><i class="fas fa-plus mr-2"></i> </button>

            </div>

            <!-- Filter Fields Section -->
            <div class="d-flex align-items-center filter-section">
                <input type="text" class="form-control height-35 f-6 mr-2" id="lead_name_filter" placeholder="Filter by Lead Name">
                <select id="lead_status_filter" class="form-control select-picker mr-2">
                    <option value="">Select Lead Status</option>
                    <option value="new">New</option>
                    <option value="contacted">Contacted</option>
                    <option value="qualified">Qualified</option>
                    <option value="converted">Converted</option>
                    <option value="lost">Lost</option>
                </select>
                <input type="date" id="start_date_filter" class="form-control height-35 f-6 mr-2">
                <input type="date" id="end_date_filter" class="form-control height-35 f-6 mr-2">
                <button class="btn btn-primary" id="applyLeadFiltersBtn"><i class="fas fa-filter mr-2"></i> </button>
            </div>


        </div>

        <table id="leadTable" class="display">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Enquiry ID</th>
                    <th>Client Name</th>
                    <th>Lead Name</th>
                    <th>Lead Status</th>
                    <th>Estimated Cost</th>
                    <th>Created At</th>
                    <th>Updated At</th>
                    <th>Action</th>

                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>

    <!-- Modal for Adding New Lead -->
    <div class="modal fade" id="addLeadModal" tabindex="-1" aria-labelledby="addLeadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addLeadModalLabel">Add New Lead</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addLeadForm">
                        <div class="mb-3">
                            <label for="enquiry_id" class="form-label">Select Enquiry</label>
                            <select id="enquiry_id" class="form-control height-35 f-14" required>
                                <!-- Options will be populated dynamically -->
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="lead_name" class="form-label">Lead Name</label>
                            <input type="text" class="form-control height-35 f-14" id="lead_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="lead_status" class="form-label">Lead Status</label>
                            <select id="lead_status" name="lead_status" class="form-control height-35 f-14">
                                <option value="new">New</option>
                                <option value="contacted">Contacted</option>
                                <option value="qualified">Qualified</option>
                                <option value="converted">Converted</option>
                                <option value="lost">Lost</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="estimated_cost" class="form-label">Estimated Cost</label>
                            <input type="number" class="form-control height-35 f-14" id="estimated_cost" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Save Lead</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Edit Lead Modal -->
    <div class="modal fade" id="editLeadModal" tabindex="-1" role="dialog" aria-labelledby="editLeadModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editLeadModalLabel">Edit Lead</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="editLeadForm">
                        <input type="hidden" id="edit_lead_id" name="id"> <!-- Hidden field for lead ID -->

                        <!-- Enquiry Dropdown -->
                        <div class="form-group">
                            <label for="edit_enquiry_id">Enquiry</label>
                            <select id="edit_enquiry_id" name="enquiry_id" class="form-control height-35 f-14">
                                <!-- This dropdown will be dynamically populated -->
                            </select>
                        </div>

                        <!-- Lead Name -->
                        <div class="form-group">
                            <label for="edit_lead_name">Lead Name</label>
                            <input type="text" id="edit_lead_name" name="lead_name" class="form-control height-35 f-14" required>
                        </div>

                        <!-- Lead Status Dropdown -->
                        <div class="form-group">
                            <label for="edit_lead_status">Lead Status</label>
                            <select id="edit_lead_status" name="lead_status" class="form-control height-35 f-14" required>
                                <option value="new">New</option>
                                <option value="contacted">Contacted</option>
                                <option value="qualified">Qualified</option>
                                <option value="converted">Converted</option>
                                <option value="lost">Lost</option>
                            </select>
                        </div>

                        <!-- Estimated Cost -->
                        <div class="form-group">
                            <label for="edit_estimated_cost">Estimated Cost</label>
                            <input type="number" id="edit_estimated_cost" name="estimated_cost" class="form-control height-35 f-14">
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Proposal Implimentations Goes here -->
<div id="proposal-tab-content" class="tab-content">
    <div class="content-wrapper">
        <div class="d-flex justify-content-between align-items-center action-bar">
            <!-- Button Group for Add New Enquiry -->
            <div class="btn-group mt-2 mt-lg-0 mt-md-0 ml-0" role="group">
                <!-- Add New Lead Button -->
                <button class="btn btn-success" id="addProposalBtn"><i class="fas fa-plus mr-2"></i> </button>&nbsp;|&nbsp;
                <button class="btn btn-success create-quotation-btn"><i class="fas fa-plus mr-2"></i> </button>

            </div>

            <!-- Filter Fields Section -->
            <div class="d-flex align-items-center filter-section">
                <input type="text" class="form-control height-35 f-6 mr-2" id="proposal_number_filter" placeholder="Filter by Proposal Number">
                <select id="proposal_status_filter" class="form-control select-picker mr-2">
                    <option value="">Select Lead Status</option>
                    <option value="new">New</option>
                    <option value="contacted">Contacted</option>
                    <option value="qualified">Qualified</option>
                    <option value="converted">Converted</option>
                    <option value="lost">Lost</option>
                </select>
                <input type="date" id="start_date_filter" class="form-control height-35 f-6 mr-2">
                <input type="date" id="end_date_filter" class="form-control height-35 f-6 mr-2">
                <button class="btn btn-primary" id="applyProposalFiltersBtn"><i class="fas fa-filter mr-2"></i> </button>
            </div>


        </div>

        <table id="proposalTable" class="display">
            <thead>
                <tr>
                    <th>Proposal ID</th>
                    <th>Lead Name</th>
                    <th>Proposal Number</th>
                    <th>Proposal Details</th>
                    <th>Total Amount</th>
                    <th>Status</th>
                    <th>Proposal Status</th>
                    <th>Created At</th>
                    <th>Updated At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>

    <!-- Modal for Adding New Lead -->
    <!-- Add Proposal Modal -->
    <div class="modal fade" id="addProposalModal" tabindex="-1" role="dialog" aria-labelledby="addProposalModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addProposalModalLabel">Add New Proposal</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Add Proposal Form -->
                    <form id="addProposalForm">
                        <!-- Lead Dropdown -->
                        <div class="form-group">
                            <label for="lead_id">Lead</label>
                            <select id="lead_id" name="lead_id" class="form-control height-35 f-6 mr-2" required>
                                <option value="">Select Lead</option> <!-- Default option will be dynamically populated -->
                            </select>
                        </div>

                        <!-- Proposal Number -->
                        <div class="form-group">
                            <label for="proposal_number">Proposal Number</label>
                            <input type="text" id="proposal_number" name="proposal_number" class="form-control height-35 f-6 mr-2" required>
                        </div>

                        <!-- Proposal Details -->
                        <div class="form-group">
                            <label for="proposal_details">Proposal Details</label>
                            <textarea id="proposal_details" name="proposal_details" class="form-control height-35 f-6 mr-2" rows="4" required></textarea>
                        </div>

                        <!-- Total Amount -->
                        <div class="form-group">
                            <label for="total_amount">Total Amount</label>
                            <input type="number" id="total_amount" name="total_amount" class="form-control height-35 f-6 mr-2" required>
                        </div>

                        <!-- Status -->
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select id="proposal_status" name="proposal_status" class="form-control height-35 f-6 mr-2" required>
                                <option value="Draft">Draft</option>
                                <option value="Sent">Sent</option>
                                <option value="Accepted">Accepted</option>
                                <option value="Rejected">Rejected</option>
                            </select>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Add Proposal</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Proposal Modal -->
    <div class="modal fade" id="editProposalModal" tabindex="-1" role="dialog" aria-labelledby="editProposalModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editProposalModalLabel">Edit Proposal</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Edit Proposal Form -->
                    <form id="editProposalForm">
                        <input type="hidden" id="edit_proposal_id" name="proposal_id"> <!-- Hidden field for proposal ID -->

                        <!-- Lead Dropdown -->
                        <div class="form-group">
                            <label for="edit_lead_id">Lead</label>
                            <select id="edit_lead_proposal_id" name="lead_id" class="form-control height-35 f-6 mr-2" required>
                                <option value="">Select Lead</option> <!-- Default option will be dynamically populated -->
                            </select>
                        </div>

                        <!-- Proposal Number -->
                        <div class="form-group">
                            <label for="edit_proposal_number">Proposal Number</label>
                            <input type="text" id="edit_proposal_number" name="proposal_number" class="form-control height-35 f-6 mr-2" required>
                        </div>

                        <!-- Proposal Details -->
                        <div class="form-group">
                            <label for="edit_proposal_details">Proposal Details</label>
                            <textarea id="edit_proposal_details" name="proposal_details" class="form-control height-35 f-6 mr-2" rows="4" required></textarea>
                        </div>

                        <!-- Total Amount -->
                        <div class="form-group">
                            <label for="edit_total_amount">Total Amount</label>
                            <input type="number" id="edit_total_amount" name="total_amount" class="form-control height-35 f-6 mr-2" required>
                        </div>

                        <!-- Status -->
                        <div class="form-group">
                            <label for="edit_status">Status</label>
                            <select id="edit_proposal_status" name="status" class="form-control height-35 f-6 mr-2" required>
                                <option value="Draft">Draft</option>
                                <option value="Sent">Sent</option>
                                <option value="Accepted">Accepted</option>
                                <option value="Rejected">Rejected</option>
                            </select>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Button to trigger the conversion to a project -->
    <!-- Modal for adding client_dispatch_info -->
    <div class="modal fade" id="dispatchInfoModal" tabindex="-1" aria-labelledby="dispatchInfoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg"> <!-- modal-lg makes the modal wider -->
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="dispatchInfoModalLabel">Add Dispatch Information and Convert to Project</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="dispatchInfoForm">
                        <input type="hidden" id="projectId" name="project_id">

                        <!-- Grid Layout: 3 columns per row -->
                        <div class="row">
                            <!-- Column 1 -->
                            <div class="col-md-4 mb-3">
                                <label for="country" class="form-label">Destination Country</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="country" name="country" required>
                                    <option value="">Select Country</option>
                                    <!-- Top Country List -->
                                    <option value="USA">United States</option>
                                    <option value="CA">Canada</option>
                                    <option value="GB">United Kingdom</option>
                                    <option value="AU">Australia</option>
                                    <option value="IN">India</option>
                                    <option value="DE">Germany</option>
                                    <option value="FR">France</option>
                                    <option value="ES">Spain</option>
                                    <option value="IT">Italy</option>
                                    <option value="BR">Brazil</option>
                                    <option value="MX">Mexico</option>
                                    <option value="JP">Japan</option>
                                    <option value="CN">China</option>
                                    <option value="RU">Russia</option>
                                    <option value="SA">South Africa</option>
                                    <option value="SG">Singapore</option>
                                    <option value="KR">South Korea</option>
                                    <option value="AE">United Arab Emirates</option>
                                    <option value="NG">Nigeria</option>
                                    <option value="ZA">South Africa</option>
                                    <option value="MY">Malaysia</option>
                                    <!-- You can add more countries here as per your requirement -->
                                </select>
                            </div>

                            <!-- Column 2 -->
                            <div class="col-md-4 mb-3">
                                <label for="medium" class="form-label">Mode of Transport</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="medium" name="medium" required>
                                    <option value="">Select Mode of Transport</option>
                                    <option value="air">Air</option>
                                    <option value="sea">Sea</option>
                                    <option value="road">Road</option>
                                    <option value="rail">Rail</option>
                                    <option value="truck">Truck</option>
                                    <option value="ship">Ship</option>
                                    <option value="express">Express</option>
                                    <option value="courier">Courier</option>
                                </select>
                            </div>


                            <!-- Column 3 -->
                            <div class="col-md-4 mb-3">
                                <label for="freight_terms" class="form-label">Freight Terms</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="freight_terms" name="freight_terms" required>
                                    <option value="">Select Freight Terms</option>
                                    <option value="FOB">FOB (Free on Board)</option>
                                    <option value="CIF">CIF (Cost, Insurance, and Freight)</option>
                                    <option value="DDP">DDP (Delivered Duty Paid)</option>
                                    <option value="DAP">DAP (Delivered at Place)</option>
                                    <option value="EXW">EXW (Ex Works)</option>
                                    <option value="CFR">CFR (Cost and Freight)</option>
                                    <option value="CPT">CPT (Carriage Paid To)</option>
                                    <option value="FCA">FCA (Free Carrier)</option>
                                </select>
                            </div>

                        </div>

                        <div class="row">
                            <!-- Column 1 -->
                            <div class="col-md-4 mb-3">
                                <label for="delivery_address" class="form-label">Delivery Address</label>
                                <textarea class="form-control height-35 f-6 mr-2" id="delivery_address" name="delivery_address" rows="3" required></textarea>
                            </div>

                            <!-- Column 2 -->
                            <div class="col-md-4 mb-3">
                                <label for="shipping_instructions" class="form-label">Shipping Instructions</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="shipping_instructions" name="shipping_instructions">
                                    <option value="">Select Shipping Instructions</option>
                                    <option value="handle_with_care">Handle with Care</option>
                                    <option value="fragile">Fragile</option>
                                    <option value="perishable">Perishable</option>
                                    <option value="keep_away_from_moisture">Keep Away from Moisture</option>
                                    <option value="do_not_stack">Do Not Stack</option>
                                    <option value="keep_in_cool_place">Keep in a Cool Place</option>
                                    <option value="urgent">Urgent</option>
                                    <option value="delivery_instructions">Delivery Instructions</option>
                                    <option value="other">Other (Specify)</option>
                                </select>
                            </div>

                            <!-- This input field appears only when 'Other' is selected -->
                            <div class="col-md-4 mb-3" id="other_instructions_container" style="display: none;">
                                <label for="other_instructions" class="form-label">Other Shipping Instructions</label>
                                <input type="text" class="form-control height-35 f-6 mr-2" id="other_instructions" name="other_instructions" placeholder="Enter custom instructions">
                            </div>

                            <!-- Column 3 -->
                            <div class="col-md-4 mb-3">
                                <label for="contact_person" class="form-label">Contact Person</label>
                                <input type="text" class="form-control height-35 f-6 mr-2" id="contact_person" name="contact_person">
                            </div>
                        </div>

                        <div class="row">
                            <!-- Column 1 -->
                            <div class="col-md-4 mb-3">
                                <label for="contact_email" class="form-label">Contact Email</label>
                                <input type="email" class="form-control height-35 f-6 mr-2" id="contact_email" name="contact_email">
                            </div>

                            <!-- Column 2 -->
                            <div class="col-md-4 mb-3">
                                <label for="contact_phone" class="form-label">Contact Phone</label>
                                <input type="text" class="form-control height-35 f-6 mr-2" id="contact_phone" name="contact_phone">
                            </div>

                            <!-- Column 3 -->
                            <div class="col-md-4 mb-3">
                                <label for="payment_terms" class="form-label">Payment Terms</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="payment_terms" name="payment_terms">
                                    <option value="">Select Payment Terms</option>
                                    <option value="net_30">Net 30</option>
                                    <option value="net_60">Net 60</option>
                                    <option value="net_90">Net 90</option>
                                    <option value="cod">Cash on Delivery (COD)</option>
                                    <option value="advance_payment">Advance Payment</option>
                                    <option value="prepaid">Prepaid</option>
                                    <option value="upon_receipt">Upon Receipt</option>
                                    <option value="upon_delivery">Upon Delivery</option>
                                    <option value="cwo">Cash with Order (CWO)</option>
                                    <option value="letter_of_credit">Letter of Credit (LC)</option>
                                    <option value="open_account">Open Account</option>
                                    <option value="eom">End of Month (EOM)</option>
                                    <option value="2_10_net_30">2/10, Net 30</option>
                                    <option value="3_15_net_45">3/15, Net 45</option>
                                    <option value="weekly_payments">Weekly Payments</option>
                                    <option value="monthly_payments">Monthly Payments</option>
                                    <option value="installment_payments">Installment Payments</option>
                                    <option value="retainer">Retainer</option>
                                    <option value="escrow_payment">Escrow Payment</option>
                                    <option value="progress_payments">Progress Payments</option>
                                </select>
                            </div>

                        </div>

                        <div class="row">
                            <!-- Column 1 -->
                            <div class="col-md-4 mb-3">
                                <label for="customs_clearance_required" class="form-label">Customs Clearance Required</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="customs_clearance_required" name="customs_clearance_required">
                                    <option value="1">Yes</option>
                                    <option value="0">No</option>
                                </select>
                            </div>

                            <!-- Column 2 -->
                            <div class="col-md-4 mb-3">
                                <label for="customs_documentation" class="form-label">Customs Documentation</label>
                                <select class="form-control form-select height-35 f-6 mr-2" id="customs_documentation" name="customs_documentation">
                                    <option value="">Select Customs Documentation</option>
                                    <option value="invoice">Commercial Invoice</option>
                                    <option value="packing_list">Packing List</option>
                                    <option value="bill_of_lading">Bill of Lading</option>
                                    <option value="certificate_of_origin">Certificate of Origin</option>
                                    <option value="export_declaration">Export Declaration</option>
                                    <option value="import_declaration">Import Declaration</option>
                                    <option value="customs_clearance">Customs Clearance Document</option>
                                    <option value="certificate_of_compliance">Certificate of Compliance</option>
                                    <option value="health_certificate">Health Certificate</option>
                                    <option value="phytosanitary_certificate">Phytosanitary Certificate</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>


                            <!-- Column 3 (Empty Column for Alignment) -->
                            <div class="col-md-4 mb-3">
                                <!-- You can add another field here if needed or leave it empty -->
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary">
                            Save Dispatch Info <sub style="font-size: 0.5em; vertical-align: super;color:#ffc107">Convert to Project</sub>
                        </button>
                        <span id="loadingSpinner" class="spinner-border spinner-border-sm" style="display:none;"></span>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
<div id="project-tab-content" class="tab-content">
    <div class="content-wrapper">
        <div class="btn-group mt-2 mt-lg-0 mt-md-0 ml-0" role="group">
            <div id="message" style="display: none;"></div>
        </div>
        <!-- Allocation Form -->

        <table id="projectsTable" class="table table-striped">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Project Name</th>
                    <th>Members</th>
                    <th>Start Date</th>
                    <th>Deadline</th>
                    <th>Client</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Data will be populated dynamically -->
            </tbody>
        </table>

    </div>

    <!-- Modal for adding client_dispatch_info -->

    <!-- Inventory Allocation Modal -->
    <!-- Modal for allocating inventory -->
    <div id="allocateInventoryModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="allocateInventoryModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="allocateInventoryModalLabel">Allocate Inventory</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Select product and allocation details -->
                    <form id="allocateInventoryForm">
                        <input type="hidden" id="project_id">
                        <div class="form-group">
                            <label for="material_name">Material</label>
                            <select class="form-control height-35 f-6" id="material_name" required>
                                <option value="">Select Material</option>
                                <!-- Dynamically populated via AJAX -->
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="quantity_in_stock">Stock Quantity</label>
                            <input type="text" class="form-control height-35 f-6" id="quantity_in_stock" disabled>
                        </div>
                        <div class="form-group">
                            <label for="location">Location</label>
                            <input type="text" class="form-control height-35 f-6" id="location" disabled>
                        </div>
                        <div class="form-group">
                            <label for="unit_price">Unit Price</label>
                            <input type="text" class="form-control height-35 f-6" id="unit_price" disabled>
                        </div>
                        <div class="form-group">
                            <label for="project_quantity">Project Quantity</label>
                            <input type="number" class="form-control height-35 f-6" id="project_quantity" required min="1">
                        </div>
                        <div class="form-group" id="purchaseOptions" style="display:none;">
                            <p>Stock is insufficient. Would you like to purchase additional stock?</p>
                            <button type="button" class="btn btn-warning" id="purchaseStockBtn">Purchase Stock</button>
                        </div>
                        <button type="submit" class="btn btn-primary">Allocate</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="inventory-tab-content" class="tab-content">
    <div class="content-wrapper">
        <!-- Message Area (Hidden by Default) -->
        <div class="btn-group mt-2 mt-lg-0 mt-md-0 ml-0" role="group">
            <div id="message" style="display: none;"></div>
        </div>

        <!-- Action Bar and Tabs Navigation -->
        <div class="d-flex justify-content-between align-items-center action-bar mb-3">
            <ul class="nav nav-tabs" id="inventoryTabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="pending-tab" data-toggle="tab" href="#pending" role="tab" aria-controls="pending" aria-selected="true">Inventory Request for Approval</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="inventory-tab" data-toggle="tab" href="#inventory" role="tab" aria-controls="inventory" aria-selected="false">Inventory Management</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="projectdispatch-tab" data-toggle="tab" href="#projectdispatch" role="tab" aria-controls="projectdispatch" aria-selected="false">Project is Ready to Dispatch</a>
                </li>
            </ul>
        </div>

        <!-- Tab Content -->
        <div class="tab-content mt-3" id="inventoryTabsContent">

            <!-- Pending for Approval Tab -->
            <div class="tab-pane fade show active" id="pending" role="tabpanel" aria-labelledby="pending-tab">
                <h4 class="mb-3">Pending Allocations for Approval</h4>
                <table class="table table-bordered display" id="pendingAllocationsTable">
                    <thead>
                        <tr>
                            <th>Project Name</th>
                            <th>Material Name</th>
                            <th>Quantity</th>
                            <th>Location</th>
                            <th>Unit Price</th>
                            <th>Material Code</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be populated via AJAX -->
                    </tbody>
                </table>
            </div>

            <!-- Inventory Management Tab -->
            <div class="tab-pane fade" id="inventory" role="tabpanel" aria-labelledby="inventory-tab">
                <h4 class="mb-3">Inventory Management</h4>
                <table id="inventory-table" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Material Name</th>
                            <th>Quantity in Stock</th>
                            <th>Location</th>
                            <th>Unit Price</th>
                            <th>Material Code</th>
                            <th>Reorder Level</th>
                            <th>Stock Location</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be populated via AJAX -->
                    </tbody>
                </table>
            </div>

            <div class="tab-pane fade" id="projectdispatch" role="tabpanel" aria-labelledby="projectdispatch-tab">
                <h4 class="mb-3">Inventory Management</h4>
                <table id="ready-to-dispatch-table" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Project Name</th>
                            <th>Project Status</th>
                            <th>Allocation Status</th>
                            <th>Inventory Quantity</th>
                            <th>Location</th>
                            <th>Unit Price</th>
                            <th>Stage Name</th>
                            <th>Batch Number</th>
                            <th>Progress</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be populated dynamically by DataTable -->
                    </tbody>
                </table>
                <!-- Modal to show full project details -->
                <div class="modal fade" id="projectDetailsModal" tabindex="-1" role="dialog" aria-labelledby="projectDetailsModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="modal-content" style="border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
                            <div class="modal-header" style="background-color: #007bff; color: white; border-top-left-radius: 8px; border-top-right-radius: 8px;">
                                <h5 class="modal-title" id="projectDetailsModalLabel">Project Details</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <!-- Project Info -->
                                <div id="project-info-section" style="padding: 15px; background-color: #f8f9fa; margin-bottom: 15px; border-radius: 8px;">
                                    <h4 style="font-size: 1.2rem; color: #333; display: flex; align-items: center; font-weight: bold;">
                                        <i class="fas fa-info-circle" style="margin-right: 10px; color: #007bff;"></i> Project Information
                                    </h4>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Project Name:</strong> <span id="project-name"></span></p>

                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Status:</strong> <span id="project-status"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Order ID:</strong> <span id="order-id"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Created At:</strong> <span id="created-at"></span></p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Dispatch Info -->
                                <!-- Dispatch Info Section in Modal -->
                                <div id="dispatch-info-section" style="padding: 15px; background-color: #f8f9fa; margin-bottom: 15px; border-radius: 8px;">
                                    <h4 style="font-size: 1.2rem; color: #333; display: flex; align-items: center; font-weight: bold;">
                                        <i class="fas fa-shipping-fast" style="margin-right: 10px; color: #007bff;"></i> Dispatch Information
                                    </h4>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Country:</strong> <span id="dispatch-country"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Medium:</strong> <span id="dispatch-medium"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Freight Terms:</strong> <span id="dispatch-freight-terms"></span></p>
                                        </div>
                                    </div>
                                    <!-- Initiate Dispatch Button -->
                                    <button id="initiate-dispatch-btn" class="btn btn-primary" style="margin-top: 15px;">Initiate Dispatch</button>

                                    <!-- Dispatch Form - Hidden by default -->
                                    <div id="dispatch-form" style="display: none; margin-top: 20px;">
                                        <form id="dispatch-form-details">
                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="project_id">Project ID</label>
                                                    <input type="text" name="projectId_for_dispatch" id="projectId_for_dispatch" class="form-control height-35 f-14" readonly>
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="dispatch_date">Dispatch Date</label>
                                                    <input type="date" name="dispatch_date" id="dispatch_date" class="form-control height-35 f-14" required>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="invoice_number">Invoice Number</label>
                                                    <input type="text" name="invoice_number" id="invoice_number" class="form-control height-35 f-14" maxlength="50">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="tracking_number">Tracking Number</label>
                                                    <input type="text" name="tracking_number" id="tracking_number" class="form-control height-35 f-14" maxlength="255">
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="dispatch_mode">Dispatch Mode</label>
                                                    <select name="dispatch_mode" id="dispatch_mode" class="form-control height-35 f-14" required>
                                                        <option value="Full">Full</option>
                                                        <option value="Partial">Partial</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="dispatch_status">Dispatch Status</label>
                                                    <select name="dispatch_status" id="dispatch_status" class="form-control height-35 f-14" required>
                                                        <option value="Pending">Pending</option>
                                                        <option value="Shipped">Shipped</option>
                                                        <option value="Delivered">Delivered</option>
                                                        <option value="Returned">Returned</option>
                                                        <option value="In Transit">In Transit</option>
                                                        <option value="Out for Delivery">Out for Delivery</option>
                                                        <option value="Dispatched to Warehouse">Dispatched to Warehouse</option>
                                                        <option value="Canceled">Canceled</option>
                                                        <option value="On Hold">On Hold</option>
                                                        <option value="Ready for Dispatch">Ready for Dispatch</option>
                                                        <option value="In Customs">In Customs</option>
                                                        <option value="Shipment Delayed">Shipment Delayed</option>
                                                        <option value="Scheduled for Pickup">Scheduled for Pickup</option>
                                                        <option value="Failed Delivery Attempt">Failed Delivery Attempt</option>
                                                        <option value="Partial Delivery">Partial Delivery</option>
                                                        <option value="Returned to Sender">Returned to Sender</option>
                                                        <option value="Delivered to Pickup Point">Delivered to Pickup Point</option>
                                                        <option value="Awaiting Customer Confirmation">Awaiting Customer Confirmation</option>
                                                        <option value="Dispatch Failed">Dispatch Failed</option>
                                                        <option value="Dispatched to Third Party">Dispatched to Third Party</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="total_dispatch_weight">Total Dispatch Weight</label>
                                                    <input type="number" name="total_dispatch_weight" id="total_dispatch_weight" class="form-control height-35 f-14" step="0.01" min="0">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="total_dispatch_value">Total Dispatch Value</label>
                                                    <input type="number" name="total_dispatch_value" id="total_dispatch_value" class="form-control height-35 f-14" step="0.01" min="0">
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="insurance_required">Insurance Required</label>
                                                    <input type="checkbox" name="insurance_required" id="insurance_required" value="1" class="height-35 f-14">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="insurance_provider">Insurance Provider</label>
                                                    <input type="text" name="insurance_provider" id="insurance_provider" class="form-control height-35 f-14" maxlength="255">
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="dispatch_priority">Dispatch Priority</label>
                                                    <input type="text" name="dispatch_priority" id="dispatch_priority" class="form-control height-35 f-14" maxlength="50">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="estimated_delivery_date">Estimated Delivery Date</label>
                                                    <input type="date" name="estimated_delivery_date" id="estimated_delivery_date" class="form-control height-35 f-14">
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="proof_of_delivery">Proof of Delivery</label>
                                                    <input type="checkbox" name="proof_of_delivery" id="proof_of_delivery" value="1" class="height-35 f-14">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="dispatch_method">Dispatch Method</label>
                                                    <input type="text" name="dispatch_method" id="dispatch_method" class="form-control height-35 f-14" maxlength="50">
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 form-group">
                                                    <label for="port_of_origin">Port of Origin</label>
                                                    <input type="text" name="port_of_origin" id="port_of_origin" class="form-control height-35 f-14" maxlength="255">
                                                </div>

                                                <div class="col-md-6 form-group">
                                                    <label for="port_of_destination">Port of Destination</label>
                                                    <input type="text" name="port_of_destination" id="port_of_destination" class="form-control height-35 f-14" maxlength="255">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label for="dispatch_notes">Dispatch Notes</label>
                                                <textarea name="dispatch_notes" id="dispatch_notes" class="form-control height-35 f-14" rows="4"></textarea>
                                            </div>

                                            <button type="submit" class="btn btn-primary">Initiate Dispatch To Client</button>
                                        </form>


                                    </div>
                                </div>


                                <!-- Inventory Info -->
                                <div id="inventory-info-section" style="padding: 15px; background-color: #f8f9fa; margin-bottom: 15px; border-radius: 8px;">
                                    <h4 style="font-size: 1.2rem; color: #333; display: flex; align-items: center; font-weight: bold;">
                                        <i class="fas fa-warehouse" style="margin-right: 10px; color: #007bff;"></i> Inventory Information
                                    </h4>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Quantity:</strong> <span id="inventory-quantity"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Location:</strong> <span id="inventory-location"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Unit Price:</strong> <span id="inventory-unit-price"></span></p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Synthesis Info Section in Modal -->
                                <div id="synthesis-info-section" style="padding: 15px; background-color: #f8f9fa; margin-bottom: 15px; border-radius: 8px;">

                                    <!-- The dynamically generated stage tables will be injected here -->
                                </div>

                            </div>
                        </div>
                    </div>
                </div>


            </div>

        </div>
    </div>
</div>

<!-- Modal for Purchasing Inventory -->
<div id="purchaseModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="purchaseModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="purchaseModalLabel">Purchase Inventory</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="purchaseForm">
                    <div class="form-group">
                        <label for="vendors">Vendors</label>
                        <select class="form-control" id="vendors" multiple required>
                            <option value="Vendor1">Vendor 1</option>
                            <option value="Vendor2">Vendor 2</option>
                            <option value="Vendor3">Vendor 3</option>
                            <!-- Add more vendors as needed -->
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="product_name">Material Name</label>
                        <input type="text" class="form-control height-35 f-14" id="product_name" readonly>
                    </div>
                    <div class="form-group">
                        <label for="material_code">Material Code</label>
                        <input type="text" class="form-control height-35 f-14" id="material_code" readonly>
                    </div>
                    <div class="form-group">
                        <label for="quantity_in_stock">Quantity in Stock</label>
                        <input type="number" class="form-control height-35 f-14" id="quantity_in_stock_avl" readonly>
                    </div>
                    <div class="form-group">
                        <label for="quantity">Required Quantity</label>
                        <input type="number" class="form-control height-35 f-14" id="quantity" required>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit Purchase</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div id="synthesis-tab-content" class="tab-content">
    <div class="content-wrapper">

        <div class="d-flex justify-content-between align-items-center action-bar">
            <!-- Button to trigger the Synthesis Process -->

            <table id="projectsTableSynthesis" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Project Name</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Material Allocation</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Rows will be filled dynamically by DataTable -->
                </tbody>
            </table>


            <!-- Table for displaying synthesis stages -->
            <!-- <table id="synthesis-stages-table" class="table">
                <thead>
                    <tr>
                        <th>Stage Name</th>
                        <th>Batch Number</th>
                        <th>Progress</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
            </tbody>
            </table> -->

            <!-- Modal to add a new synthesis stage -->
            <div class="modal fade" id="addStageModal" tabindex="-1" role="dialog" aria-labelledby="addStageModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content" style="padding: 20px;">
                        <div class="modal-header">
                            <h5 class="modal-title" id="addStageModalLabel">Add Synthesis Stage</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="addStageForm">
                                <div class="row">
                                    <!-- Stage Name (Grid 1 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="stage-name">Stage Name</label>
                                        <select id="stage-name" class="form-control height-35 f-14" required style="border-radius: 5px;">
                                            <option value="T1">T1</option>
                                            <option value="T2">T2</option>
                                            <option value="T3">T3</option>
                                        </select>
                                    </div>

                                    <!-- Batch Number (Grid 2 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="batch-number">Batch Number</label>
                                        <input type="number" class="form-control height-35 f-14" id="batch-number" placeholder="Enter Batch Number" required style="border-radius: 5px;">
                                    </div>

                                    <!-- Progress (Grid 3 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="progress">Progress (%)</label>
                                        <input type="number" class="form-control height-35 f-14" id="progress" placeholder="Enter Progress" step="0.01" min="0" max="100" required style="border-radius: 5px;">
                                    </div>

                                    <!-- Reaction (Grid 1 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="reaction">Reaction</label>
                                        <input type="text" class="form-control height-35 f-14" id="reaction" placeholder="Enter Reaction" style="border-radius: 5px;">
                                    </div>

                                    <!-- Scale (Grid 2 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="scale">Scale</label>
                                        <input type="text" class="form-control height-35 f-14" id="scale" placeholder="Enter Scale" style="border-radius: 5px;">
                                    </div>

                                    <!-- Yield (Grid 3 of 3) -->
                                    <div class="form-group col-md-4">
                                        <label for="yield">Yield</label>
                                        <input type="number" class="form-control height-35 f-14" id="yield" placeholder="Enter Yield" step="0.01" style="border-radius: 5px;">
                                    </div>

                                    <!-- Experimental Conditions (Grid 1 of 2) -->
                                    <div class="form-group col-md-12">
                                        <label for="experimental-conditions">Experimental Conditions</label>
                                        <textarea class="form-control"
                                            id="experimental-conditions"
                                            placeholder="Enter Experimental Conditions"
                                            style="border-radius: 5px; height: 180px;"></textarea>
                                    </div>


                                    <!-- Results (Grid 2 of 2) -->
                                    <div class="form-group col-md-12">
                                        <label for="results">Results</label>
                                        <textarea class="form-control" id="results" rows="8" placeholder="Enter Results" style="border-radius: 5px; height: 180px;"></textarea>
                                    </div>

                                    <!-- Data (Grid 1 of 3) -->
                                    <div class="form-group col-md-12">
                                        <label for="data">Data</label>
                                        <textarea class="form-control" id="data" rows="8" placeholder="Enter Additional Data" style="border-radius: 5px; height: 180px;"></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <style>
                                            div#help {
                                                text-align: right;
                                            }

                                            div#help a {
                                                text-decoration: none;
                                            }

                                            span.glyphicon-new-window {
                                                font-size: 10px;
                                                top: 0;
                                                margin-left: 8px;
                                            }

                                            button {
                                                vertical-align: top;
                                            }

                                            #marvin-sketch {
                                                width: 100%;
                                                height: 560px;
                                                border: 1px solid #ddd;
                                                margin-bottom: 20px;
                                            }

                                            .form-control {
                                                font-size: 12px;
                                            }

                                            table.sketch-output tr {
                                                vertical-align: top;
                                            }

                                            table.sketch-output td {
                                                padding-bottom: 4px;
                                            }

                                            td.output-name {
                                                padding: 2px 8px 2px 0;
                                                text-align: right;
                                            }

                                            #sketch-output,
                                            #search-panel {
                                                display: none;
                                            }

                                            #smiles-output,
                                            #inchi-output {
                                                padding: 4px 8px;
                                                border: 1px solid #ddd;
                                                border-radius: 4px;
                                            }

                                            table.controls td {
                                                padding: 0 8px 8px 0;
                                            }

                                            table.controls td.control-label {
                                                line-height: 30px;
                                            }

                                            table.controls td.control-descriptor {
                                                width: 100%;
                                            }

                                            table.controls td.control-radio {
                                                padding-right: 0;
                                            }

                                            table.controls td.control-radio-label {
                                                padding-right: 16px;
                                            }

                                            table.controls td.control-go {
                                                padding-left: 8px;
                                            }

                                            table.controls input[type='text'] {
                                                height: 30px;
                                            }

                                            table.controls input[type='radio'] {
                                                margin: 8px 2px 0 0;
                                            }

                                            table.controls select {
                                                width: auto;
                                            }
                                        </style>
                                        <script src="https://marvinjs.chemicalize.com/v1/fee1636947874650a146cd1c75eb40c2/client-settings.js"></script>
                                        <script src="https://marvinjs.chemicalize.com/v1/client.js"></script>
                                        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                                        <script>
                                            var apiUrl = "https://data.rcsb.org/"
                                            var placeholders = {
                                                inchi: 'e.g., InChI=1S/C10H16N...',
                                                smiles: 'e.g., c1nc(c2c(n1)n(cn...',
                                                ccdid: 'e.g., AMP'
                                            }

                                            var descriptors = {
                                                inchi: 'InChI',
                                                smiles: 'SMILES',
                                                ccdid: 'Chemical Component ID'
                                            }

                                            var query = {
                                                service: 'chemical',
                                                parameters: {
                                                    type: 'descriptor'
                                                }
                                                //, label: 'chemical'
                                            }

                                            var marvinSketcherInstance

                                            function loadMolecule() {
                                                var descriptor = $('#descriptor').val(),
                                                    value = $.trim($('#descriptor-value').val())

                                                if (value.length > 0) {
                                                    if (descriptor === 'ccdid') {
                                                        $.ajax({
                                                            type: 'GET',
                                                            url: apiUrl + 'rest/v1/core/chemcomp/' + value,
                                                            dataType: 'json',
                                                            success: function(data) {
                                                                var mol = data.rcsb_chem_comp_descriptor.smilesstereo;
                                                                marvinSketcherInstance.importStructure('smiles', mol);
                                                            },
                                                            error: function() {
                                                                alert('Not a valid ' + descriptors[descriptor])
                                                            }
                                                        })
                                                    } else {
                                                        marvinSketcherInstance.importStructure(descriptor, value) // returns promise - see https://marvinjs-demo.chemaxon.com/latest/jsdoc.html
                                                            .then(
                                                                function(result) {},
                                                                function(error) {
                                                                    console.log(error)
                                                                    alert('Not a valid ' + descriptors[descriptor])
                                                                }
                                                            )
                                                    }
                                                } else {
                                                    alert('No value was entered for Load Molecule.')
                                                }
                                            }

                                            //- reset value and set placeholder
                                            function selectDescriptor() {
                                                var descriptor = $('#descriptor').val()

                                                $('#descriptor-value').val('')
                                                $('#descriptor-value').attr('placeholder', placeholders[descriptor])
                                            }

                                            function getQuery(descriptorType, value, match_type) {
                                                query.parameters.value = value
                                                query.parameters.descriptor_type = descriptorType;
                                                query.parameters.match_type = match_type;
                                                return '/search?query=' + encodeURIComponent(JSON.stringify(query)) + '&return_type=mol_definition';
                                            }

                                            function search() {
                                                var descriptor = $('input[name="search-descriptor"]:checked').val(),
                                                    val = $('#' + descriptor + '-output').html(),
                                                    match_type = $('#match-type').val()

                                                console.log(descriptor, val, match_type)

                                                if (val.length === 0) alert('No ' + descriptors[descriptor] + ' value is present')
                                                else location.href = getQuery(descriptors[descriptor], val, match_type)
                                            }

                                            $(function() {
                                                selectDescriptor() // init descriptor placeholder

                                                // set match_type if param exists
                                                var match_type = new URLSearchParams(window.location.search).get('match_type')
                                                if (match_type) $('#match-type').val(match_type).prop('selected', true)
                                            })
                                        </script>
                                        <div id="help"><a href="/docs/search-and-browse/advanced-search/chemical-sketch-tool">Help<span class="glyphicon glyphicon-new-window"></span></a></div>
                                        <label for="results">Chemical Tool</label>
                                        <div id="marvin-sketch"></div>
                                        <div class="panel panel-default">
                                            <div class="panel-heading">Load Molecule</div>
                                            <div class="panel-body">
                                                <table class="controls">
                                                    <tbody>
                                                        <tr>
                                                            <td class="control-label">Descriptor</td>
                                                            <td><select class="form-control input-sm" id="descriptor" onchange="selectDescriptor()">
                                                                    <option value="inchi">InChI</option>
                                                                    <option value="smiles">SMILES</option>
                                                                    <option value="ccdid">Chemical Component ID</option>
                                                                </select></td>
                                                        </tr>
                                                        <tr>
                                                            <td></td>
                                                            <td class="control-descriptor"><input class="form-control" id="descriptor-value" type="text" placeholder="e.g., c1nc(c2c(n1)n(cn..."></td>
                                                            <td><button class="btn btn-default btn-sm" type="button" onclick="loadMolecule()">Load</button></td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <script>
                                            ChemicalizeMarvinJs.createEditor('#marvin-sketch').then(function(marvin) {
                                                marvinSketcherInstance = marvin

                                                var urlParams = new URLSearchParams(window.location.search) // this convenient function has incomplete browser coverage (no IE) - should use a more generic function here
                                                    ,
                                                    descriptor_type = urlParams.get('descriptor_type'),
                                                    value = urlParams.get('value')


                                                if (descriptor_type && value) marvin.importStructure(descriptor_type, value)

                                                function handleMolChange() {
                                                    marvin.exportStructure('smiles').then(function(smiles) {
                                                        console.log(smiles + ' ' + typeof smiles)
                                                        if (!smiles || smiles.length === 0) {
                                                            $('#sketch-output').hide()
                                                            $('#search-panel').hide()
                                                        } else {
                                                            $('#sketch-output').show()
                                                            $('#search-panel').show()
                                                        }

                                                        $('#smiles-output').html(smiles)
                                                    });
                                                    marvin.exportStructure('inchi').then(function(inchi) {
                                                        console.log(inchi)
                                                        // actual inchi comes in first line
                                                        $('#inchi-output').html(inchi.split('\n')[0])
                                                    });
                                                }

                                                marvin.on('molchange', handleMolChange)
                                            });
                                        </script>

                                    </div>

                                    <!-- Hidden project_id input field -->
                                    <input type="hidden" id="modal-project-id">
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal" style="border-radius: 5px; padding: 10px;">Close</button>
                            <button type="submit" form="addStageForm" class="btn btn-primary" style="border-radius: 5px; padding: 10px;">Save Stage</button>
                        </div>

                    </div>
                </div>
            </div>


            <!-- Modal for Manager Approval Request -->
            <div class="modal fade" id="managerApprovalModal" tabindex="-1" role="dialog" aria-labelledby="managerApprovalModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="managerApprovalModalLabel">Request Manager Approval</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="approvalForm">
                                <div class="form-group">
                                    <label for="approval-comments">Approval Comments</label>
                                    <textarea class="form-control" id="approval-comments" rows="4"></textarea>
                                </div>
                                <input type="hidden" id="projectId">
                                <input type="hidden" id="stageId">
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary" id="submit-approval">Submit Request</button>

                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal to View Synthesis Stages -->
            <!-- Modal Structure -->
            <div class="modal fade" id="stagesModal" tabindex="-1" role="dialog" aria-labelledby="stagesModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document" style="max-width:360mm; padding: 20px;">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="stagesModalLabel">Synthesis Stage Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body" id="stagesModalBody">
                            <!-- Stage details will be populated here -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- Button to trigger the modal to add a new stage -->



            <!-- Synthesis Stages Table (Hidden initially) -->
            <!-- <div id="synthesis-content" style="display:none;">
                <h3>Synthesis Stages</h3>
                <table id="synthesis-stages-table" class="table">
                    <thead>
                        <tr>
                            <th>Stage Name</th>
                            <th>Batch Number</th>
                            <th>Progress</th>
                            <th>Comments</th>
                            <th>Approval</th>
                        </tr>
                    </thead>
                    <tbody>
                      
            </tbody>
            </table>
        </div> -->


        </div>
    </div>
</div>


<div id="dispatch-tab-content" class="tab-content">
    <div class="content-wrapper">

        <div class="d-flex justify-content-between align-items-center action-bar">
            <table id="dispatchInfoDetails" class="table table-striped" style="width: 100%;overflow-x: auto;">

            </table>

        </div>
    </div>
</div>



<!-- Modal for Project Details and Comment Submission -->
<div class="modal fade" id="projectDetailsModal" tabindex="-1" aria-labelledby="projectDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="projectDetailsModalLabel">Project Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><strong>Project ID:</strong> <span id="project_id_val"></span></p>
                <p><strong>Project Name:</strong> <span id="project_name_for_Syn"></span></p>
                <p><strong>Status:</strong> <span id="project-status"></span></p>
                <p><strong>Created At:</strong> <span id="project-created-at"></span></p>

                <!-- Textarea for entering comment -->
                <div class="form-group">
                    <label for="comment-text">Enter your comment:</label>
                    <textarea id="comment-text" class="form-control" rows="3" placeholder="Enter your comment"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="submit-comment">Submit Comment</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal: Create Quotation -->
<div class="modal fade" id="createQuotationModal" tabindex="-1" role="dialog" aria-labelledby="createQuotationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createQuotationModalLabel">Create Quotation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="createQuotationForm">
                    <input type="hidden" id="proposal_id" name="proposal_id">
                    <div class="form-group">
                        <label for="quotation_details">Quotation Details</label>
                        <textarea id="quotation_details" name="quotation_details" class="form-control height-35 f-6 mr-2" rows="3"></textarea>
                    </div>

                    <!-- Quotation Items -->
                    <h4>Quotation Items</h4>
                    <div id="items-container">
                        <!-- Dynamic items will be appended here -->
                    </div>

                    <!-- Add New Item Button -->
                    <button type="button" id="add-item-btn" class="btn btn-secondary">Add Item</button>

                    <!-- Submit Button -->
                    <div class="form-group mt-3">
                        <button type="submit" class="btn btn-primary">Create Quotation</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php echo $__env->make('sections.datatable_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Bootstrap Select JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.1/dist/js/bootstrap-select.min.js"></script>

<!-- Date Range Picker JS -->
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>


<script>
    $(document).ready(function() {
        // Initialize SelectPicker
        $('.selectpicker').selectpicker();

        // Initialize Date Range Picker
        $('#date-range-picker').daterangepicker();
    });
</script>

<script>
    $(document).ready(function() {
        $('#vendors').select2({
            width: '100%' // This makes the select element fill its container
        });

        //enquiryContent();

        $('#enquiry-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();
            enquiryContent();

        });

        $('#lead-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();


            leadContent();
        });

        $('#proposal-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();


            proposalContent();
        });
        projectsTableData();
        $('#project-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').show();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();

            projectsTableData();

        });

        $('#inventory-tab').on('click', function(e) {
            e.preventDefault();
            loadPendingAllocations();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').show();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();

        });

        $('#synthesis-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').show();
            $('#dispatch-tab-content').hide();
            loadProjectDetails();
        });

        $('#dispatch-tab').on('click', function(e) {
            e.preventDefault();
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').hide();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').show();
            loadDispatchDetails();
        });



        function hideAllTabContents() {
            $('#enquiry-tab-content').hide();
            $('#lead-tab-content').hide();
            $('#proposal-tab-content').hide();
            $('#inventory-tab-content').hide();
            $('#project-tab-content').show();
            $('#synthesis-tab-content').hide();
            $('#dispatch-tab-content').hide();

        }

        // Call this function initially to ensure no content is shown when the page loads
        hideAllTabContents();
        $('#shipping_instructions').change(function() {
            if ($(this).val() === 'other') {
                $('#other_instructions_container').show();
            } else {
                $('#other_instructions_container').hide();
            }
        });

        function enquiryContent() {
            // Show Add Enquiry Modal and reset form
            $('#addEnquiryBtn').on('click', function() {
                $('#addEnquiryModal').modal('show');
                $('#addEnquiryForm')[0].reset(); // Reset form data when opening the modal
            });

            if ($.fn.dataTable.isDataTable('#enquiriesTable')) {
                // Destroy the existing DataTable instance
                enquiriesTable.clear().destroy();
            }
            var enquiriesTable = $('#enquiriesTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('enquiries.data')); ?>",
                    type: "GET",
                    data: function(d) {
                        // Pass any filters you want to send to the server
                        d.client_name = $('#client_name_filter').val();
                        d.project_name = $('#project_name_filter').val();
                        d.status = $('#status_filter').val();
                        d.start_date = $('#start_date_filter').val();
                        d.end_date = $('#end_date_filter').val();
                    }
                },
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'client_name'
                    },
                    {
                        data: 'project_name'
                    },
                    {
                        data: 'description'
                    },
                    {
                        data: 'status'
                    },
                    {
                        data: 'created_at',
                        render: function(data) {
                            return new Date(data).toLocaleDateString();
                        }
                    },
                    {
                        data: 'updated_at',
                        render: function(data) {
                            return new Date(data).toLocaleDateString();
                        }
                    },
                    {
                        data: null,
                        render: function(data, type, row) {
                            return '<button class="btn btn-warning edit-btn" data-id="' + row.id + '">' +
                                '<i class="fas fa-edit"></i>' +
                                '</button>';
                        }
                    }

                ],
                pageLength: 25,
                lengthMenu: [10, 25, 50, 100],
                scrollX: true,
                order: [
                    [0, 'desc']
                ],
                columnDefs: [{
                        targets: 0,
                        width: '50px',

                    },
                    {
                        targets: 1,
                        width: '250px',
                        className: 'text-left'
                    },
                    {
                        targets: 2,
                        width: '250px',
                        className: 'text-left'
                    },
                    {
                        targets: 3,
                        width: '250px',
                        className: 'text-left'
                    },
                    {
                        targets: 4,
                        width: '50px',
                        className: 'text-center'
                    },
                    {
                        targets: 5,
                        width: '100px',
                        className: 'text-center'
                    },
                    {
                        targets: 6,
                        width: '150px',
                        className: 'text-center'
                    }
                ]
            });

            // Apply Filters on Button Click
            $('#applyFiltersBtn').on('click', function() {
                // Reload the DataTable with the new filters
                enquiriesTable.ajax.reload();
            });

            // Handle form submission for adding a new enquiry
            $('#addEnquiryForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission

                // Collect form data
                var formData = {
                    client_name: $('#client_name').val(),
                    project_name: $('#project_name').val(),
                    description: $('#description').val(),
                    status: $('#status').val(),
                };

                $.ajax({
                    url: '/account/addEnquiry',
                    method: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        alert('Enquiry added successfully.');
                        $('#addEnquiryModal').modal('hide');
                        $('#addEnquiryForm')[0].reset(); // Reset the form after submission
                        loadEnquiries(); // Reload the enquiry list
                    },
                    error: function(xhr, status, error) {
                        console.error('Error adding enquiry:', error);
                        alert('There was an error adding the enquiry. Please try again.');
                    }
                });
            });

            // Handle form submission for editing an enquiry
            $('#editEnquiryForm').on('submit', function(e) {
                e.preventDefault();

                var formData = $(this).serialize();

                $.ajax({
                    url: '/account/updateEnquiry', // Route for updating the enquiry
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        // Close the modal and reload the table
                        $('#editEnquiryModal').modal('hide');
                        alert('Enquiry updated successfully.');
                        loadEnquiries(); // Reload enquiries after update
                    },
                    error: function(error) {
                        console.error('Error updating enquiry:', error);
                    }
                });
            });

            // Initial load of enquiries when the page is ready
            // loadEnquiries();


            $(document).on('click', '.edit-btn', function() {
                var enquiryId = $(this).data('id');

                // Get the enquiry details for editing
                $.ajax({
                    url: '/account/getEnquiriesById/' + enquiryId,
                    method: 'GET',
                    success: function(response) {
                        var enquiry = response.data[0];

                        // Populate the form with the enquiry data for editing
                        $('#client_name_val').val(enquiry.client_name);
                        $('#project_name_val').val(enquiry.project_name);
                        $('#description_val').val(enquiry.description);
                        $('#status_val').val(enquiry.status);
                        $('#enquiry_id_val').val(enquiry.id); // Hidden field for the enquiry ID

                        // Show the edit modal
                        $('#editEnquiryModal').modal('show');
                    },
                    error: function(error) {
                        console.error('Error fetching enquiry:', error);
                    }
                });
            });


        }

        // Lead Functinality Goes here
        function leadContent() {

            if ($.fn.dataTable.isDataTable('#leadTable')) {
                // Destroy the existing DataTable instance
                leadsTable.clear().destroy();
            }
            var leadsTable = $('#leadTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('leads.data')); ?>",
                    type: "GET",
                    data: function(d) {
                        console.log(d);
                        // Pass any filters you want to send to the server
                        d.lead_name_filter = $('#lead_name_filter').val();
                        d.lead_status_filter = $('#lead_status_filter').val();
                        d.start_date = $('#start_date_filter').val();
                        d.end_date = $('#end_date_filter').val();
                    }
                },
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'enquiry_id',

                    }, // Display the Enquiry ID
                    {
                        data: 'client_name',

                    }, // Display Client Name from Enquiry
                    {
                        data: 'lead_name'
                    },
                    {
                        data: 'lead_status'
                    },
                    {
                        data: 'estimated_cost'
                    },
                    {
                        data: 'created_at',
                        render: function(data) {
                            return new Date(data).toLocaleDateString();
                        }
                    },
                    {
                        data: 'updated_at',
                        render: function(data) {
                            return new Date(data).toLocaleDateString();
                        }
                    },
                    {
                        data: null,
                        render: function(data, type, row) {
                            return '<button class="btn btn-warning edit-lead-btn" data-id="' + row.id + '">' +
                                '<i class="fas fa-edit"></i>' +
                                '</button>';
                        }
                    }
                ],
                pageLength: 25,
                lengthMenu: [10, 25, 50, 100],
                scrollX: true,
                order: [
                    [0, 'desc']
                ],
                columnDefs: [{
                        targets: 0,
                        width: '50px',

                    },
                    {
                        targets: 1,
                        width: '50px',
                        className: 'text-left'
                    },
                    {
                        targets: 2,
                        width: '150px',
                        className: 'text-left'
                    },
                    {
                        targets: 3,
                        width: '150px',
                        className: 'text-left'
                    },
                    {
                        targets: 4,
                        width: '150px',
                        className: 'text-center'
                    },
                    {
                        targets: 5,
                        width: '100px',
                        className: 'text-center'
                    },
                    {
                        targets: 6,
                        width: '150px',
                        className: 'text-center'
                    }
                ]
            });


            // Open the modal when the "Add New Lead" button is clicked
            $('#addLeadBtn').on('click', function() {
                // Open the modal
                $('#addLeadModal').modal('show');

                // Reset the form when opening the modal
                $('#addLeadForm')[0].reset();

                // Fetch existing enquiries to populate the dropdown
                fetchEnquiries();
            });

            // Function to fetch existing enquiries and populate the dropdown
            function fetchEnquiries() {
                $.ajax({
                    url: "<?php echo e(route('enquiries.data')); ?>",
                    method: 'GET',
                    success: function(response) {
                        var enquiries = response.data;
                        var $enquirySelect = $('#enquiry_id');
                        $enquirySelect.empty(); // Clear existing options

                        // Add a default option
                        $enquirySelect.append('<option value="">Select Enquiry</option>');

                        // Populate the dropdown with the enquiry data
                        enquiries.forEach(function(enquiry) {
                            $enquirySelect.append(
                                '<option value="' + enquiry.id + '">' + enquiry.client_name + ' - ' + enquiry.project_name + '</option>'
                            );
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching enquiries:', error);
                    }
                });
            }

            // Handle form submission for adding a new lead
            $('#addLeadForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission

                // Collect form data
                var formData = {
                    enquiry_id: $('#enquiry_id').val(),
                    lead_name: $('#lead_name').val(),
                    lead_status: $('#lead_status').val(),
                    estimated_cost: $('#estimated_cost').val(),
                };

                // Validate that enquiry_id is selected
                if (!formData.enquiry_id) {
                    alert('Please select an enquiry.');
                    return;
                }

                // Send the data to the server
                $.ajax({
                    url: '/account/addLeads', // API endpoint to save the new lead
                    method: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF token for Laravel
                    },
                    success: function(response) {
                        alert('Lead added successfully!');
                        $('#addLeadModal').modal('hide'); // Close the modal
                        $('#addLeadForm')[0].reset(); // Reset the form
                        loadLeads(); // Reload the leads table
                    },
                    error: function(xhr, status, error) {
                        console.error('Error adding lead:', error);
                        alert('There was an error adding the lead. Please try again.');
                    }
                });
            });


            // Edit Lead Button Click Event
            $(document).on('click', '.edit-lead-btn', function() {
                var leadId = $(this).data('id'); // Get the lead ID from the button data-id attribute

                // Make an AJAX request to fetch the lead data
                $.ajax({
                    url: '/account/get-lead-by-id/' + leadId, // API endpoint to get the lead by ID
                    method: 'GET',
                    success: function(response) {
                        if (response.success) {
                            var lead = response.data;
                            var enquiries = response.enquiries;

                            // Populate the form fields with the lead data
                            $('#edit_lead_id').val(lead.id);
                            $('#edit_lead_name').val(lead.lead_name);
                            $('#edit_lead_status').val(lead.lead_status);
                            $('#edit_estimated_cost').val(lead.estimated_cost);

                            // Populate the enquiry dropdown
                            var enquiryDropdown = $('#edit_enquiry_id');
                            enquiryDropdown.empty(); // Clear existing options

                            // Add a default option
                            enquiryDropdown.append('<option value="">Select Enquiry</option>');

                            // Loop through the enquiries to populate the dropdown
                            enquiries.forEach(function(enquiry) {
                                var selected = lead.enquiry_id == enquiry.id ? 'selected' : ''; // Pre-select the correct enquiry
                                enquiryDropdown.append('<option value="' + enquiry.id + '" ' + selected + '>' + enquiry.client_name + '</option>');
                            });

                            // Show the modal
                            $('#editLeadModal').modal('show');
                        } else {
                            alert('Lead not found');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('Error fetching lead data: ' + error);
                        alert('An error occurred while fetching the lead data.');
                    }
                });
            });


            $(document).on('submit', '#editLeadForm', function(e) {
                e.preventDefault(); // Prevent the form from submitting normally

                var leadId = $('#edit_lead_id').val(); // Get the lead ID
                var enquiryId = $('#edit_enquiry_id').val(); // Get the selected enquiry ID
                var leadName = $('#edit_lead_name').val(); // Get the lead name
                var leadStatus = $('#edit_lead_status').val(); // Get the selected lead status
                var estimatedCost = $('#edit_estimated_cost').val(); // Get the estimated cost

                // Prepare the data for the update request
                var formData = {
                    id: leadId,
                    enquiry_id: enquiryId,
                    lead_name: leadName,
                    lead_status: leadStatus,
                    estimated_cost: estimatedCost
                };

                // Make an AJAX request to update the lead
                $.ajax({
                    url: '/account/update-lead', // URL to the update endpoint
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            alert('Lead updated successfully!');
                            $('#editLeadModal').modal('hide'); // Close the modal after success

                            // Optionally, refresh the table or perform any other necessary actions here
                            // For example: $('#leadsTable').DataTable().ajax.reload();
                        } else {
                            alert('Failed to update the lead');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.log('Error:', error);
                        alert('An error occurred while updating the lead.');
                    }
                });
            });

            // Apply Filters on Button Click
            $('#applyLeadFiltersBtn').on('click', function() {
                // Reload the DataTable with the new filters
                leadsTable.ajax.reload();
            });
        }




        // Lead Functinality Goes here
        function proposalContent() {
            $('[data-bs-toggle="tooltip"]').tooltip();
            if ($.fn.dataTable.isDataTable('#proposalTable')) {
                // Destroy the existing DataTable instance
                proposalTable.clear().destroy();
            }

            // Initialize DataTable for proposals
            var proposalsTable = $('#proposalTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(route('proposal.data')); ?>",
                    type: "GET",
                    data: function(d) {
                        // Pass filter data to the server
                        d.proposal_number = $('#proposal_number_filter').val();
                        d.lead_name = $('#lead_name_filter').val();
                        d.client_name = $('#client_name_filter').val();
                        d.status = $('#status_filter').val();
                        d.start_date = $('#start_date_filter').val();
                        d.end_date = $('#end_date_filter').val();
                    }
                },
                columns: [{
                        data: 'id'
                    },
                    {
                        data: 'lead_id'
                    },
                    {
                        data: 'proposal_number'
                    },
                    {
                        data: 'proposal_details'
                    },
                    {
                        data: 'total_amount'
                    },
                    {
                        data: 'status'
                    },
                    {
                        data: 'proposal_status',
                        render: function(data, type, row) {
                            console.log(data);
                            // Check if the proposal status is 1 (Proposal Converted to Project)
                            if (data === 1) {
                                return '<span class="badge badge-success">Proposal Converted to Project</span>';
                            } else {
                                return '<span class="badge badge-warning">Proposal Not Converted</span>';
                            }
                        }
                    }, {
                        data: 'created_at',
                        render: function(data, type, row) {
                            if (data) {
                                var date = new Date(data);
                                var yyyy = date.getFullYear();
                                var mm = String(date.getMonth() + 1).padStart(2, '0'); // Add leading zero if month is single digit
                                var dd = String(date.getDate()).padStart(2, '0'); // Add leading zero if day is single digit
                                return dd + '-' + mm + '-' + yyyy; // Return date in 'YYYY-MM-DD' format
                            }
                            return ''; // Return empty string if no date is available
                        }
                    }, {
                        data: 'updated_at',
                        render: function(data, type, row) {
                            if (data) {
                                var date = new Date(data);
                                var yyyy = date.getFullYear();
                                var mm = String(date.getMonth() + 1).padStart(2, '0');
                                var dd = String(date.getDate()).padStart(2, '0');
                                return dd + '-' + mm + '-' + yyyy; // Return date in 'YYYY-MM-DD' format
                            }
                            return ''; // Return empty string if no date is available
                        }
                    }, {
                        data: null,
                        render: function(data, type, row) {
                            return `
            <div class="btn-group" role="group" aria-label="Proposal Actions">
                <!-- Edit Button with Tooltip -->
                <button class="btn btn-warning btn-sm edit-proposal-btn" data-id="${row.id}" title="Edit Proposal" data-bs-toggle="tooltip" data-bs-placement="top">
                    <i class="fas fa-edit"></i>
                </button>
                <!-- Create Quotation Button with Tooltip -->
                <button class="btn btn-primary btn-sm create-quotation-btn" data-id="${row.id}" title="Create Quotation" data-bs-toggle="tooltip" data-bs-placement="top">
                    <i class="fas fa-file-alt"></i>
                </button>
                <!-- Convert to Project Button with Tooltip -->
                <button class="btn btn-success btn-sm convert-to-project-btn" data-id="${row.id}" title="Convert to Project" data-bs-toggle="tooltip" data-bs-placement="top">
                    <i class="fas fa-project-diagram"></i>
                </button>
            </div>
        `;
                        }
                    }
                ],
                columnDefs: [{
                        targets: 0,
                        width: "80px"
                    }, // ID
                    {
                        targets: 1,
                        width: "100px"
                    }, // Lead ID
                    {
                        targets: 2,
                        width: "150px"
                    }, // Proposal Number
                    {
                        targets: 3,
                        width: "300px"
                    }, // Proposal Details
                    {
                        targets: 4,
                        width: "120px"
                    }, // Total Amount
                    {
                        targets: 5,
                        width: "100px"
                    }, // Status
                    {
                        targets: 6,
                        width: "150px"
                    }, // Created At
                    {
                        targets: 7,
                        width: "150px"
                    }, // Updated At
                    {
                        targets: 8,
                        width: "100px"
                    }, // Action Buttons (larger width for buttons)
                ],
                pageLength: 25,
                lengthMenu: [10, 25, 50, 100],
                scrollX: true,
                order: [
                    [0, 'desc']
                ]
            });

            // Apply filters when button is clicked
            $('#applyProposalFiltersBtn').on('click', function() {
                proposalsTable.ajax.reload();
            });

            // Handle Edit Proposal Button Click
            $(document).on('click', '.edit-proposal-btn', function() {
                var proposalId = $(this).data('id'); // Get the proposal ID from the button

                // Make an AJAX request to fetch the proposal data
                $.ajax({
                    url: '/account/get-proposal-by-id/' + proposalId, // Endpoint for fetching the proposal by ID
                    method: 'GET',
                    success: function(response) {
                        console.log(response); // Log the response to the console for debugging

                        if (response.success) {
                            var proposal = response.data;
                            var leads = response.leads; // Array of leads returned by the API
                            // Populate the form fields with the proposal data
                            $('#edit_proposal_id').val(proposal.proposal_id);
                            $('#edit_proposal_number').val(proposal.proposal_number);
                            $('#edit_proposal_details').val(proposal.proposal_details);
                            $('#edit_total_amount').val(proposal.total_amount);
                            $('#edit_proposal_status').val(proposal.status);

                            // Populate the leads dropdown (if leads are available)
                            var $leadSelect = $('#edit_lead_proposal_id');
                            $leadSelect.empty(); // Clear existing options
                            $leadSelect.append('<option value="">Select Lead</option>'); // Default option

                            if (leads && leads.length > 0) {
                                leads.forEach(function(lead) {
                                    var selected = lead.id === proposal.lead_id ? 'selected' : ''; // Check if the lead is selected
                                    $leadSelect.append('<option value="' + lead.id + '" ' + selected + '>' + lead.lead_name + '</option>');
                                });
                            } else {
                                $leadSelect.append('<option value="">No leads available</option>'); // If no leads are found
                            }

                            // Show the modal
                            $('#editProposalModal').modal('show');
                        } else {
                            alert('Proposal not found');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching proposal data: ' + error);
                        alert('An error occurred while fetching the proposal.');
                    }
                });
            });



            // Handle Proposal Edit Form Submission
            $('#editProposalForm').on('submit', function(e) {
                e.preventDefault();
                var formData = $(this).serialize();
                $.ajax({
                    url: '/account/update-proposal',
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            alert('Proposal updated successfully!');
                            $('#editProposalModal').modal('hide');
                            proposalsTable.ajax.reload();
                        } else {
                            alert('Failed to update the proposal');
                        }
                    },
                    error: function() {
                        alert('Error updating the proposal');
                    }
                });
            });

            // Open the modal when "Add Proposal" button is clicked
            $('#addProposalBtn').on('click', function() {
                // Open the modal
                $('#addProposalModal').modal('show');

                // Reset the form when opening the modal
                $('#addProposalForm')[0].reset();

                // Fetch leads to populate the dropdown
                fetchLeads();
            });

            // Function to fetch existing leads and populate the dropdown
            function fetchLeads() {
                $.ajax({
                    url: "<?php echo e(route('leads.data')); ?>", // Make sure this route returns a list of leads
                    method: 'GET',
                    success: function(response) {
                        var leads = response.data;
                        var $leadSelect = $('#lead_id');
                        $leadSelect.empty(); // Clear existing options

                        // Add a default option
                        $leadSelect.append('<option value="">Select Lead</option>');

                        // Populate the dropdown with leads
                        leads.forEach(function(lead) {
                            $leadSelect.append('<option value="' + lead.id + '">' + lead.lead_name + '</option>');
                        });
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching leads:', error);
                    }
                });
            }

            // Handle form submission for adding a new proposal
            $('#addProposalForm').on('submit', function(e) {
                e.preventDefault(); // Prevent the default form submission

                // Collect form data
                var formData = {
                    lead_id: $('#lead_id').val(),
                    proposal_number: $('#proposal_number').val(),
                    proposal_details: $('#proposal_details').val(),
                    total_amount: $('#total_amount').val(),
                    proposal_status: $('#proposal_status').val(),
                };

                // Validate that lead_id is selected
                if (!formData.lead_id) {
                    alert('Please select a lead.');
                    return;
                }

                // Send the data to the server
                $.ajax({
                    url: '/account/addProposal', // API endpoint to save the new proposal
                    method: 'POST',
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF token for Laravel
                    },
                    success: function(response) {
                        alert('Proposal added successfully!');
                        $('#addProposalModal').modal('hide'); // Close the modal
                        $('#addProposalForm')[0].reset(); // Reset the form
                        loadProposals(); // Reload the proposals table (you may need to implement this)
                    },
                    error: function(xhr, status, error) {
                        console.error('Error adding proposal:', error);
                        alert('There was an error adding the proposal. Please try again.');
                    }
                });
            });

        }

        $(document).on('click', '.convert-to-project-btn', function() {
            var proposalId = $(this).data('id'); // Get the proposal ID
            $('#dispatchInfoModal').modal('show'); // Show the modal to add dispatch info
            $('#projectId').val(proposalId); // Set the project ID in the modal form
            // Make an AJAX request to convert the proposal to a project and open the modal

        });

        // Handle the form submission to save dispatch info
        $('#dispatchInfoForm').on('submit', function(e) {
            e.preventDefault(); // Prevent form from submitting normally
            $('#loadingSpinner').show();
            $('#saveDispatchInfoBtn').prop('disabled', true);
            var formData = $(this).serialize(); // Serialize form data

            // AJAX request to save the dispatch info
            $.ajax({
                url: '/account/convert-to-project', // Backend endpoint to save dispatch info
                method: 'POST',
                data: formData, // Send the form data, including project_id and other dispatch info
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.status === 'success') {
                        alert('Dispatch info saved successfully!');
                        $('#dispatchInfoModal').modal('hide'); // Hide the modal
                        $('#loadingSpinner').hide(); // Hide the spinner
                        $('#saveDispatchInfoBtn').prop('disabled', false); // Enable the button
                        // Optionally, refresh the table or update the UI
                        proposalsTable.ajax.reload(); // Assuming you're using DataTables
                    } else {
                        alert('Error saving dispatch info');
                    }
                },
                error: function() {
                    $('#loadingSpinner').hide(); // Hide the spinner
                    $('#saveDispatchInfoBtn').prop('disabled', false); // Enable the button
                    alert('An error occurred while saving dispatch info');
                }
            });
        });

        // Handle Material Allocation
        $('#allocateMaterialBtn').on('click', function() {
            var materialId = $('#material_id').val();
            var quantity = $('#quantity').val();
            var projectId = $('#project_id').val(); // The project ID

            if (!materialId || !quantity) {
                alert('Please select material and enter quantity');
                return;
            }

            // Make AJAX request to allocate material
            $.ajax({
                url: '/account/allocate-material', // API endpoint to allocate material
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    project_id: projectId,
                    material_id: materialId,
                    quantity: quantity
                },
                success: function(response) {
                    if (response.status === 'success') {
                        alert('Material allocated successfully');
                        // Optionally, update inventory and project data
                    } else {
                        alert('Failed to allocate material');
                    }
                },
                error: function() {
                    alert('An error occurred while allocating the material');
                }
            });
        });


        // Fetch inventory data
        function fetchInventory() {
            $.ajax({
                url: '/account/get-inventory', // API to get inventory data
                method: 'GET',
                success: function(response) {
                    var materials = response.data;
                    var $materialSelect = $('#material_id');
                    $materialSelect.empty(); // Clear existing options
                    $materialSelect.append('<option value="">Select Material</option>');

                    materials.forEach(function(material) {
                        $materialSelect.append('<option value="' + material.id + '">' + material.material_name + '</option>');
                    });
                },
                error: function() {
                    alert('An error occurred while fetching the inventory');
                }
            });
        }



        $(document).ready(function() {

            // Handle the "Create Quotation" button click
            $(document).on('click', '.create-quotation-btn', function() {
                var proposalId = $(this).data('id'); // Get the proposal ID from the button

                // Make an AJAX request to fetch the proposal details
                $.ajax({
                    url: '/account/get-proposal-by-id/' + proposalId, // Endpoint to fetch proposal details by ID
                    method: 'GET',
                    success: function(response) {
                        if (response.success) {
                            var proposal = response.data;
                            var leads = response.leads; // Array of leads returned by the API
                            // Populate hidden field with the proposal ID
                            $('#proposal_id').val(response.data.id);

                            // Populate the quotation details (if any)
                            $('#quotation_details').val(response.data.proposal_details);

                            // Clear existing items
                            $('#items-container').empty();

                            // Populate the quotation items (if any)
                            if (response.data && Array.isArray(response.data.quotation_items)) {
                                response.data.quotation_items.forEach(function(item, index) {
                                    addItemRow(item, index);
                                });
                            } else {
                                console.error("quotation_items is not an array or is undefined");
                                // Optionally, you can display an alert or handle the case when it's missing
                            }

                            // Show the modal
                            $('#createQuotationModal').modal('show');
                        } else {
                            alert('Proposal not found!');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching proposal data:', error);
                        alert('An error occurred while fetching the proposal data.');
                    }
                });
            });

            // Add new item row in the form
            var itemCount = 0; // Keep track of the number of items
            function addItemRow(item = {}, index = itemCount) {
                var newItemRow = `
        <div class="item-row" data-index="${index}">
            <div class="form-group">
                <label for="molecule-${index}">Molecule</label>
                <input type="text" name="items[${index}][molecule]" id="molecule-${index}" class="form-control height-35 f-6 mr-2" value="${item.molecule || ''}" required>
            </div>
            <div class="form-group">
                <label for="quantity-${index}">Quantity</label>
                <input type="number" name="items[${index}][quantity]" id="quantity-${index}" class="form-control height-35 f-6 mr-2" value="${item.quantity || ''}" required>
            </div>
            <div class="form-group">
                <label for="wastage_percent-${index}">Wastage (%)</label>
                <input type="number" name="items[${index}][wastage_percent]" id="wastage_percent-${index}" class="form-control height-35 f-6 mr-2" value="${item.wastage_percent || ''}" required>
            </div>
            <div class="form-group">
                <label for="price-${index}">Price</label>
                <input type="number" name="items[${index}][price]" id="price-${index}" class="form-control height-35 f-6 mr-2" value="${item.price || ''}" required>
            </div>
            <button type="button" class="btn btn-danger remove-item-btn">Remove Item</button>
        </div>
    `;
                $('#items-container').append(newItemRow);
                itemCount++;
            }

            // Add new item row when the "Add Item" button is clicked
            $('#add-item-btn').click(function() {
                addItemRow();
            });

            // Remove item row when "Remove Item" button is clicked
            $(document).on('click', '.remove-item-btn', function() {
                $(this).closest('.item-row').remove();
            });

            // Handle form submission
            $('#createQuotationForm').submit(function(e) {
                e.preventDefault();

                // Serialize form data
                var formData = $(this).serialize();

                // Make an AJAX request to create the quotation
                $.ajax({
                    url: '/account/create-quotation',
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        if (response.success) {
                            alert('Quotation created successfully!');
                            $('#createQuotationModal').modal('hide');
                            // Optionally, reload or update the page
                        } else {
                            alert('Failed to create quotation');
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error creating quotation:', error);
                        alert('An error occurred while creating the quotation.');
                    }
                });
            });
        });

    });


    function projectsTableData() {
        // Initialize DataTable for Projects
        if ($.fn.dataTable.isDataTable('#projectsTable')) {
            // Destroy the existing DataTable instance
            projectsTable.clear().destroy();
        }
        var projectsTable = $('#projectsTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "/account/get_projects", // URL to fetch the projects
                type: "GET"
            },
            columns: [{
                    data: 'project_short_code', // Assuming the project code is stored as 'project_short_code'
                    render: function(data) {
                        return data || 'N/A'; // Fallback in case the code is empty
                    }
                },
                {
                    data: 'project_name'
                },
                {
                    data: 'members', // This field should be available in the API response
                    render: function(data) {
                        // Assuming the members are stored as a string or a JSON array
                        return data ? data.join(', ') : 'No Members'; // If it's an array, join them by commas
                    }
                },
                {
                    data: 'start_date',
                    render: function(data) {
                        return new Date(data).toLocaleDateString(); // Format date as per your needs
                    }
                },
                {
                    data: 'deadline',
                    render: function(data) {
                        return new Date(data).toLocaleDateString(); // Format date as per your needs
                    }
                },
                {
                    data: 'client_name', // This is where client_name will be rendered
                    render: function(data, type, row) {
                        console.log(row);
                        // Display both client name and company name in the same column
                        var companyName = row.company_name || 'No Company';

                        // Use href to make the client_name clickable (for example, using client_id or some other field)
                        var clientLink = `<a href="/account/clients/${row.user_id}" target="_blank">${data}</a>`;

                        return `${clientLink}<br>(${companyName})`; // Concatenate client name and company name with href
                    }
                },

                {
                    data: 'status',
                    render: function(data) {
                        switch (data) {
                            case 'Not Started':
                                return `<span class="badge badge-warning">${data}</span>`;
                            case 'In Progress':
                                return `<span class="badge badge-info">${data}</span>`;
                            case 'Completed':
                                return `<span class="badge badge-success">${data}</span>`;
                            default:
                                return `<span class="badge badge-secondary">Unknown</span>`;
                        }
                    }
                },
                {
                    data: 'allocation_status',
                    render: function(data, type, row) {
                        let badgeClass;
                        let buttonHtml; // Default button

                        // Assign badge colors based on the allocation status
                        switch (data) {
                            case 'Pending':
                                badgeClass = 'badge-warning';
                                buttonHtml = `<button class="btn btn-warning allocate-inventory-btn" data-id="${row.id}">Allocate Inventory</button>`;
                                break;
                            case 'Under Purchase':
                                badgeClass = 'badge-info';
                                buttonHtml = '';
                                break;
                            case 'Awaiting Response from Vendor':
                                badgeClass = 'badge-secondary';
                                buttonHtml = '';
                                break;
                            case 'Allocated':
                                badgeClass = 'badge-success';
                                buttonHtml = `<button class="btn btn-primary synthesis-btn" data-id="${row.id}">Start Synthesis</button>`; // Button for Allocated status
                                break;
                            case 'Waiting for Inventory Store Approval':
                                badgeClass = 'badge-danger';
                                buttonHtml = '';
                                break;
                            default:
                                badgeClass = 'badge-secondary';
                                buttonHtml = '';
                                break;
                        }

                        // Return badge and button HTML// <span class="badge ${badgeClass}">${data}</span>
                        return `
            ${buttonHtml}
        `;
                    }
                }

            ],
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            order: [
                [2, 'desc'] // Sort by 'created_at' in descending order
            ]
        });

    }


    $(document).ready(function() {
        var projectId = null;

        // Event listener for "Allocate Inventory" button
        $(document).on('click', '.allocate-inventory-btn', function() {
            projectId = $(this).data('id');
            $('#project_id').val(projectId);
            $('#allocateInventoryModal').modal('show');
            loadInventoryOptions(); // Load inventory materials
        });


        // Function to load inventory materials
        function loadInventoryOptions() {
            $.ajax({
                url: '/account/get_inventory_materials',
                type: 'GET',
                success: function(response) {
                    var options = '<option value="">Select Material</option>';
                    response.materials.forEach(function(material) {
                        options += `<option value="${material.id}">${material.material_name}</option>`;
                    });
                    $('#material_name').html(options);
                },
                error: function(err) {
                    alert('Error fetching inventory materials');
                }
            });
        }

        // Event listener for material selection
        $('#material_name').on('change', function() {
            var materialId = $(this).val();
            if (materialId) {
                // Fetch the stock details of the selected material
                $.ajax({
                    url: '/account/get_inventory_details/' + materialId,
                    type: 'GET',
                    success: function(response) {
                        // Populate stock details
                        $('#quantity_in_stock').val(response.stock_quantity);
                        $('#location').val(response.location);
                        $('#unit_price').val(response.unit_price);

                        // Show purchase options if stock is insufficient
                        var requiredQuantity = $('#project_quantity').val();
                        var stockQuantity = parseFloat(response.stock_quantity);
                        if (stockQuantity < requiredQuantity) {
                            $('#purchaseOptions').show();
                        } else {
                            $('#purchaseOptions').hide();
                        }
                    },
                    error: function(err) {
                        alert('Error fetching inventory details');
                    }
                });
            } else {
                // Clear fields when no material is selected
                $('#quantity_in_stock').val('');
                $('#location').val('');
                $('#unit_price').val('');
                $('#purchaseOptions').hide();
            }
        });

        // Handle inventory allocation form submission
        $('#allocateInventoryForm').submit(function(e) {
            e.preventDefault();
            var data = {
                project_id: $('#project_id').val(),
                material_name: $('#material_name').val(),
                quantity_in_stock: $('#quantity_in_stock').val(),
                location: $('#location').val(),
                unit_price: $('#unit_price').val(),
                project_quantity: $('#project_quantity').val(),
                _token: $('meta[name="csrf-token"]').attr('content')
            };

            $.ajax({
                url: '/account/allocate_inventory',
                type: 'POST',
                data: data,
                success: function(response) {
                    alert(response.message);
                    $('#allocateInventoryModal').modal('hide');
                    $('#projectsTable').DataTable().ajax.reload();
                },
                error: function(err) {
                    alert('Error allocating inventory');
                }
            });
        });

        // Handle "Purchase Stock" button click
        $('#purchaseStockBtn').on('click', function() {
            alert('Redirecting to purchase page...');
            // You can add logic to redirect to a purchase page or open a purchase modal
        });
    });

    $('#inventoryTabs a').on('shown.bs.tab', function(e) {
        var targetTab = $(e.target).attr('href'); // get target tab
        if (targetTab === "#pending") {
            loadPendingAllocations();
        } else if (targetTab === "#inventory") {
            loadInventoryData();
        } else if (targetTab === "#projectdispatch") {
            loadReadyToDispatch();
        }

    });

    // Function to load Pending Allocations
    function loadPendingAllocations() {
        $(document).ready(function() {
            // Initialize DataTable with server-side processing
            if ($.fn.dataTable.isDataTable('#pendingAllocationsTable')) {
                // Destroy the existing DataTable instance
                pendingAllocationsTable.clear().destroy();
            }
            var pendingAllocationsTable = $('#pendingAllocationsTable').DataTable({
                destroy: true,
                processing: true,
                serverSide: true,
                ajax: {
                    url: '/account/pending_for_approval', // URL to fetch the pending allocations
                    type: 'GET',
                    dataSrc: function(json) {
                        // Handle response data and populate the table
                        if (json.data.length === 0) {
                            //alert('No pending allocations found.');
                        }
                        return json.data;
                    }
                },
                columns: [{
                        data: 'project_name'
                    }, // Project name from manufacturing_projects
                    {
                        data: 'material_name'
                    }, // Material name from inventory
                    {
                        data: 'quantity'
                    }, // Quantity from inventory_allocations
                    {
                        data: 'location'
                    }, // Location from inventory
                    {
                        data: 'unit_price'
                    }, // Unit price from inventory
                    {
                        data: 'material_code'
                    }, // Material code from inventory
                    {
                        data: 'allocation_id', // Allocation ID for the action buttons
                        render: function(data, type, row) {
                            return `
                        <button class="btn btn-success approve-btn" data-id="${data}">Approve</button>
                    `;
                        }
                    }
                ],

                pageLength: 10,
                lengthMenu: [10, 25, 50, 100],
                order: [
                    [0, 'asc']
                ] // Default sorting by project name
            });

            // Approve Allocation Button
            $(document).on('click', '.approve-btn', function() {
                var allocationId = $(this).data('id');
                var button = $(this);
                // Send request to approve allocation
                $.ajax({
                    url: '/account/approve-inventory-allocation/' + allocationId,
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        // Update the status and disable the button
                        alert(response.message);
                        button.prop('disabled', true).text('Approved');
                        var row = button.closest('tr'); // Find the table row that contains the clicked button
                        row.find('.allocation-status').text('Approved');
                        table.ajax.reload(null, false);

                    },
                    error: function(xhr, status, error) {
                        console.error('Error:', error);
                        alert('Failed to approve allocation.');
                    }
                });
            });
        });

    }

    // Function to load Inventory Management data
    function loadInventoryData() {
        $(document).ready(function() {

            if ($.fn.dataTable.isDataTable('#inventory-table')) {
                // Destroy the existing DataTable instance
                inventoryTable.clear().destroy();
            }
            var inventoryTable = $('#inventory-table').DataTable({
                processing: true, // Enable the processing indicator
                serverSide: false, // Use client-side processing for simpler debugging
                ajax: {
                    url: '/account/inventory', // URL to fetch the inventory data
                    type: 'GET',
                    dataSrc: function(json) {
                        // Log the server response for debugging
                        console.log(json);

                        // If the response does not have data or is empty, return an empty array
                        if (!json || !json.length) {
                            return [];
                        }

                        // Process rows to highlight those with low stock
                        json.forEach(function(row) {
                            if (parseFloat(row.quantity_in_stock) < 1000) {
                                // Add the 'low-stock' class for highlighting
                                row['DT_RowClass'] = 'low-stock';
                            }
                        });

                        // Return the data for DataTable to use
                        return json;
                    }
                },
                columns: [{
                        data: 'material_name'
                    }, // Material Name
                    {
                        data: 'quantity_in_stock'
                    }, // Quantity in stock
                    {
                        data: 'location'
                    }, // Location
                    {
                        data: 'unit_price'
                    }, // Unit Price
                    {
                        data: 'material_code'
                    }, // Material Code
                    {
                        data: 'reorder_level'
                    }, // Reorder Level
                    {
                        data: 'stock_location'
                    }, // Stock Location
                    {
                        data: null,
                        render: function(data, type, row) {
                            // Render the 'Purchase' button only if stock is below 100
                            if (parseFloat(row.quantity_in_stock) < 1000) {
                                return `<button class="purchase-btn" data-id="${row.id}" data-name="${row.material_name}" data-code="${row.material_code}" data-quantity="${row.quantity_in_stock}">
                                    Purchase
                                </button>`;
                            }
                            return ''; // Return empty if stock is sufficient
                        }
                    }
                ]
            });

            // When "Purchase" button is clicked
            $('#inventory-table').on('click', '.purchase-btn', function() {
                var button = $(this);
                var productName = button.data('name');
                var materialCode = button.data('code');
                var availableQuantity = button.data('quantity');

                // Log the data to ensure it's being passed correctly
                console.log('Product Name:', productName);
                console.log('Material Code:', materialCode);
                console.log('Available Quantity:', availableQuantity);

                // Populate the modal fields with product data
                $('#product_name').val(productName);
                $('#material_code').val(materialCode);
                $('#quantity_in_stock_avl').val(availableQuantity); // This should be pre-populated

                // Show the modal
                $('#purchaseModal').modal('show');
            });

            // Handle the form submission for purchasing the product
            $('#purchaseForm').submit(function(e) {
                e.preventDefault();

                var quantity = $('#quantity').val();
                var materialName = $('#product_name').val();
                var materialCode = $('#material_code').val();
                var vendors = $('#vendors').val(); // Array of selected vendors

                // Validate required fields
                if (!quantity || !vendors.length) {
                    alert('Please provide the required quantity and select at least one vendor.');
                    return;
                }

                // Make an AJAX call to process the purchase
                $.ajax({
                    url: '/account/purchaseInventory', // Your endpoint to handle the purchase
                    type: 'POST',
                    data: {
                        material_name: materialName,
                        material_code: materialCode,
                        quantity: quantity,
                        vendors: vendors // Send the selected vendors
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        // Close the modal and reload the table
                        alert('Purchase successful!');
                        $('#purchaseModal').modal('hide');
                        $('#inventory-table').DataTable().ajax.reload(); // Reload the table data
                    },
                    error: function(xhr, status, error) {
                        alert('Failed to process the purchase.');
                    }
                });
            });


            // Handle the 'Check Stock' form submission using AJAX
            $(document).on('submit', '.check-stock-form', function(e) {
                e.preventDefault();
                var form = $(this);
                var data = form.serialize();

                $.ajax({
                    url: '/account/check-inventory', // Your route for checking stock
                    type: 'POST',
                    data: data,
                    success: function(response) {
                        $('#message').css('color', 'green').text(response.message).show();
                    },
                    error: function(xhr) {
                        var response = xhr.responseJSON;
                        $('#message').css('color', 'red').text(response.message).show();
                    }
                });
            });

            // Handle the 'Allocate' form submission using AJAX
            $(document).on('submit', '.allocate-form', function(e) {
                e.preventDefault();
                var form = $(this);
                var data = form.serialize();

                $.ajax({
                    url: '/account/allocate-raw-material', // Your route for allocation
                    type: 'POST',
                    data: data,
                    success: function(response) {
                        $('#message').css('color', 'green').text(response.message).show();
                        var productId = form.find('input[name="product_id"]').val();
                        var quantity = form.find('input[name="quantity"]').val();
                        $('#product-' + productId + ' .stock-quantity').text(function(index, oldText) {
                            return parseInt(oldText) - parseInt(quantity);
                        });
                    },
                    error: function(xhr) {
                        var response = xhr.responseJSON;
                        $('#message').css('color', 'red').text(response.message).show();
                    }
                });
            });

            // Handle the 'Purchase' form submission using AJAX
            $(document).on('submit', '.purchase-form', function(e) {
                e.preventDefault();
                var form = $(this);
                var data = form.serialize();

                $.ajax({
                    url: '/account/purchase-raw-material', // Your route for purchase
                    type: 'POST',
                    data: data,
                    success: function(response) {
                        $('#message').css('color', 'green').text(response.message).show();
                    },
                    error: function(xhr) {
                        var response = xhr.responseJSON;
                        $('#message').css('color', 'red').text(response.message).show();
                    }
                });
            });
        });

    }

    function loadReadyToDispatch() {
        // Initialize the DataTable
        $(document).ready(function() {

            if ($.fn.dataTable.isDataTable('#ready-to-dispatch-table')) {
                // Destroy the existing DataTable instance
                readyTodispatchtable.clear().destroy();
            }

            var readyTodispatchtable = $('#ready-to-dispatch-table').DataTable({
                processing: true,
                serverSide: false,
                ajax: {
                    url: '/account/project_ready_to_dispatch', // URL to fetch data
                    type: 'GET',
                    dataSrc: function(json) {
                        console.log(json); // Log for debugging

                        if (!json.data || !json.data.length) {
                            return [];
                        }

                        var processedData = json.data.map(function(row) {
                            return {
                                project_name: row.project_name,
                                project_status: row.project_status,
                                allocation_status: row.allocation_status,
                                quantity: row.total_allocated,
                                location: row.location || 'N/A',
                                unit_price: row.unit_price || 'N/A',
                                stage_name: row.stage_names,
                                batch_number: row.batch_numbers,
                                progress: row.progresses,
                                project_id: row.project_id,
                                stage_id: row.stage_ids,
                                dispatch_status: row.dispatch_status,
                                stage_comments: row.stage_comments || 'N/A',
                                approval_statuses: row.approval_statuses || 'N/A',
                                approval_comments: row.approval_comments || 'N/A'
                            };
                        });

                        return processedData;
                    }
                },
                columns: [{
                        data: 'project_name'
                    },
                    {
                        data: 'project_status'
                    },
                    {
                        data: 'allocation_status'
                    },
                    {
                        data: 'quantity'
                    },
                    {
                        data: 'location'
                    },
                    {
                        data: 'unit_price'
                    },
                    {
                        data: 'stage_name',
                        render: function(data) {
                            return `<span class="badge badge-info">${data}</span>`;
                        }
                    },
                    {
                        data: 'batch_number'
                    },
                    {
                        data: 'progress',
                        render: function(data) {
                            return `<span class="badge badge-success">${data}%</span>`;
                        }
                    },
                    {
                        data: 'project_id', // Assuming the project_id is returned from the API
                        render: function(data, type, row) {
                            console.log(row.dispatch_status);
                            // Check if dispatch_status is empty (i.e., NULL or empty string)
                            if (!row.dispatch_status || row.dispatch_status === '') {
                                // If dispatch_status is empty, render the button
                                return `
                        <button class="btn btn-warning btn-sm view-project-details" 
                                data-project-id="${data}" 
                                title="Dispatch" 
                                data-bs-toggle="tooltip" 
                                data-bs-placement="top">
                            <i class="fas fa-truck" style="color: black;"></i>
                        </button>
                    `;
                            } else {
                                var badgeClass = '';

                                // Check dispatch_status and map it to the corresponding badge
                                switch (data) {
                                    case 'Pending':
                                        badgeClass = 'badge-secondary'; // grey
                                        break;
                                    case 'Shipped':
                                        badgeClass = 'badge-info'; // blue
                                        break;
                                    case 'Delivered':
                                        badgeClass = 'badge-success'; // green
                                        break;
                                    case 'Returned':
                                        badgeClass = 'badge-danger'; // red
                                        break;
                                    case 'In Transit':
                                        badgeClass = 'badge-primary'; // dark blue
                                        break;
                                    case 'Out for Delivery':
                                        badgeClass = 'badge-warning'; // yellow
                                        break;
                                    case 'Dispatched to Warehouse':
                                        badgeClass = 'badge-light'; // light color
                                        break;
                                    case 'Canceled':
                                        badgeClass = 'badge-dark'; // dark grey
                                        break;
                                    case 'On Hold':
                                        badgeClass = 'badge-warning'; // yellow
                                        break;
                                    case 'Ready for Dispatch':
                                        badgeClass = 'badge-info'; // light blue
                                        break;
                                    case 'In Customs':
                                        badgeClass = 'badge-secondary'; // grey
                                        break;
                                    case 'Shipment Delayed':
                                        badgeClass = 'badge-warning'; // yellow
                                        break;
                                    case 'Scheduled for Pickup':
                                        badgeClass = 'badge-primary'; // dark blue
                                        break;
                                    case 'Failed Delivery Attempt':
                                        badgeClass = 'badge-danger'; // red
                                        break;
                                    case 'Partial Delivery':
                                        badgeClass = 'badge-warning'; // yellow
                                        break;
                                    case 'Returned to Sender':
                                        badgeClass = 'badge-danger'; // red
                                        break;
                                    case 'Delivered to Pickup Point':
                                        badgeClass = 'badge-success'; // green
                                        break;
                                    case 'Awaiting Customer Confirmation':
                                        badgeClass = 'badge-info'; // blue
                                        break;
                                    case 'Dispatch Failed':
                                        badgeClass = 'badge-danger'; // red
                                        break;
                                    case 'Dispatched to Third Party':
                                        badgeClass = 'badge-light'; // light color
                                        break;
                                    default:
                                        badgeClass = 'badge-secondary'; // default grey color
                                }

                                // Return the badge HTML
                                return `<span class="badge ${badgeClass}" style="font-size: 14px; padding: 6px 12px;">${row.dispatch_status}</span>`;

                            }
                        }
                    }
                ],
                scrollX: true,
                scrollY: '400px',
                paging: true,
                lengthChange: true,
                searching: true,
            });

            // Handle click on View Details button
            $('#ready-to-dispatch-table').on('click', '.view-project-details', function() {
                const projectId = $(this).data('project-id');

                // Make an AJAX request to fetch the full project details
                $.ajax({
                    url: '/account/project_full_info/' + projectId, // Endpoint to fetch full project details
                    type: 'GET',
                    success: function(response) {
                        if (response.status === 'success') {
                            const project = response.data;

                            // Populate project details in the modal
                            $('#projectId_for_dispatch').val(projectId);
                            $('#project-name').text(project.project_name);
                            $('#project-status').text(project.project_status);
                            $('#order-id').text(project.order_id);
                            $('#created-at').text(project.created_at);

                            // Populate dispatch info
                            $('#dispatch-country').text(project.dispatch_country);
                            $('#dispatch-medium').text(project.dispatch_medium);
                            $('#dispatch-freight-terms').text(project.dispatch_freight_terms);

                            // Populate inventory info
                            $('#inventory-quantity').text(project.total_allocated);
                            $('#inventory-location').text(project.inventory_location);
                            $('#inventory-unit-price').text(project.inventory_unit_price);

                            // Synthesis Stages
                            let stagesHtml = ''; // Variable to hold dynamic HTML for stages

                            stagesHtml += `<h4 style="font-size: 1.2rem; color: #333; display: flex; align-items: center; font-weight: bold;">
                                <i class="fas fa-cogs" style="margin-right: 10px; color: #007bff;"></i> Synthesis Stages
                            </h4>`;

                            response.data.synthesis_stages.forEach(function(stage) {
                                stagesHtml += `
                    <div class="stage" style="margin-bottom: 20px;">
                        <table class="table table-bordered" style="width: 100%; table-layout: fixed; border-collapse: collapse; font-size: 12px; margin-bottom: 15px;">
                            <thead>
                                <tr style="background-color: #f8f9fa; text-align: center;">
                                    <th style="padding: 8px;">Stage Name</th>
                                    <th style="padding: 8px;">Batch Number</th>
                                    <th style="padding: 8px;">Progress</th>
                                    <th style="padding: 8px;">Reaction</th>
                                    <th style="padding: 8px;">Scale</th>
                                    <th style="padding: 8px;">Experimental Conditions</th>
                                    <th style="padding: 8px;">Results</th>
                                    <th style="padding: 8px;">Yield</th>
                                    <th style="padding: 8px;">Data</th>
                                    <th style="padding: 8px;">Comment</th>
                                    <th style="padding: 8px;">Manager Approval</th>
                                    <th style="padding: 8px;">Approval Comments</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="text-align: center;">
                                    <td style="padding: 8px;">${stage.stage_name}</td>
                                    <td style="padding: 8px;">${stage.batch_number}</td>
                                    <td style="padding: 8px;">${stage.progress}%</td>
                                    <td style="padding: 8px;">${stage.reaction || 'No reaction provided'}</td>
                                    <td style="padding: 8px;">${stage.scale || 'Not specified'}</td>
                                    <td style="padding: 8px;">${stage.experimental_conditions || 'No conditions specified'}</td>
                                    <td style="padding: 8px;">${stage.results || 'No results provided'}</td>
                                    <td style="padding: 8px;">${stage.yield || 'No yield data'}</td>
                                    <td style="padding: 8px;">${stage.data || 'No data provided'}</td>
                                    <td style="padding: 8px;">${stage.comment || 'No comments'}</td>
                                    <td style="padding: 8px;">
                                        <span class="badge" style="background-color: ${stage.manager_approval_status ? '#28a745' : '#dc3545'}; color: white;">
                                            ${stage.manager_approval_status ? 'Approved' : 'Not Approved'}
                                        </span>
                                    </td>
                                    <td style="padding: 8px;">${stage.approval_comments || 'No approval comments'}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    `;
                            });

                            // Inject the stages HTML into the modal
                            $('#synthesis-info-section').html(stagesHtml);

                            // Open the modal
                            $('#projectDetailsModal').modal('show');

                            // Show the "Initiate Dispatch" form when the button is clicked
                            $('#initiate-dispatch-btn').on('click', function() {
                                $('#dispatch-form').show();
                                $(this).hide();
                            });

                            // Handle form submission
                            $('#dispatch-form-details').on('submit', function(event) {
                                event.preventDefault(); // Prevents the default form submission

                                // Create an object to hold the form data
                                const dispatchData = {
                                    project_id: $('#projectId_for_dispatch').val(),
                                    dispatch_date: $('#dispatch_date').val(),
                                    invoice_number: $('#invoice_number').val(),
                                    tracking_number: $('#tracking_number').val(),
                                    dispatch_mode: $('#dispatch_mode').val(),
                                    dispatch_status: $('#dispatch_status').val(),
                                    total_dispatch_weight: $('#total_dispatch_weight').val(),
                                    total_dispatch_value: $('#total_dispatch_value').val(),
                                    insurance_required: $('#insurance_required').is(':checked') ? 1 : 0, // Checkbox
                                    insurance_provider: $('#insurance_provider').val(),
                                    dispatch_priority: $('#dispatch_priority').val(),
                                    estimated_delivery_date: $('#estimated_delivery_date').val(),
                                    proof_of_delivery: $('#proof_of_delivery').is(':checked') ? 1 : 0, // Checkbox
                                    dispatch_method: $('#dispatch_method').val(),
                                    port_of_origin: $('#port_of_origin').val(),
                                    port_of_destination: $('#port_of_destination').val(),
                                    dispatch_notes: $('#dispatch_notes').val(),
                                    _token: $('meta[name="csrf-token"]').attr('content') // CSRF token for Laravel
                                };

                                // Make the AJAX request to save the dispatch info
                                $.ajax({
                                    url: '/account/order_shipping_details', // Laravel route to save dispatch info
                                    type: 'POST',
                                    data: dispatchData,
                                    success: function(response) {
                                        if (response.status === 'success') {
                                            alert('Order dispatchment information saved successfully!');
                                            // Optionally clear the form or hide modal
                                            $('#dispatch-form-details')[0].reset();
                                            $('#projectDetailsModal').modal('hide'); // If you're using a modal, you can hide it
                                        } else {
                                            alert('Error saving order dispatch information: ' + response.message);
                                        }
                                    },
                                    error: function() {
                                        alert('An error occurred while saving order dispatch information.');
                                    }
                                });
                            });
                        } else {
                            alert('Error fetching project details');
                        }
                    },
                    error: function() {
                        alert('Error fetching project details');
                    }
                });
            });



        });
    }



    $(document).on('click', '.synthesis-btn', function() {
        var projectId = $(this).data('id'); // Get project ID from button
        $('#synthesis-tab').addClass('active'); // Make the tab active
        $('#enquiry-tab-content').hide();
        $('#lead-tab-content').hide();
        $('#proposal-tab-content').hide();
        $('#inventory-tab-content').hide();
        $('#project-tab-content').hide();
        $('#synthesis-tab-content').hide();

        // Show the Synthesis content (it may be hidden initially)
        $('#synthesis-tab-content').show();

        // Fetch and display the synthesis stages for the selected project
        $('#project-details').show(); // Show project details section

        // Load the initial project details (if not loaded already)
        loadProjectDetails();

        // Load synthesis stages for the project
        loadSynthesisStages(projectId);
    });

    // Function to load the initial project details
    function loadProjectDetails() {
        if ($.fn.dataTable.isDataTable('#projectsTableSynthesis')) {
            // Destroy the existing DataTable instance
            projectsTableSynthesis.clear().destroy();
        }
        var projectsTableSynthesis = $('#projectsTableSynthesis').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "/account/get_project_details", // URL to fetch the projects
                type: "GET"
            },
            columns: [{
                    data: 'project_name'
                },
                {
                    data: 'status'
                },
                {
                    data: 'created_at'
                },
                {
                    data: 'allocation_status', // Allocation status column
                    render: function(data, type, row) {
                        let badgeClass = '';
                        switch (data) {
                            case 'Allocated':
                                badgeClass = 'badge-success';
                                break;
                            case 'Under Purchase':
                                badgeClass = 'badge-info';
                                break;
                            case 'Awaiting Response from Vendor':
                                badgeClass = 'badge-warning';
                                break;
                            case 'Waiting for Inventory Store Approval':
                                badgeClass = 'badge-primary';
                                break;
                            default:
                                badgeClass = 'badge-secondary';
                        }
                        return `<span class="badge ${badgeClass}">${data}</span>`;
                    }
                },
                {
                    data: 'id',
                    render: function(data, type, row) {
                        // Ensure stage_names and progresses are available and split safely
                        const stages = row.stage_names ? row.stage_names.split(',') : [];
                        const progresses = row.progresses ? row.progresses.split(',').map(Number) : [];

                        // Check if 'T3' stage exists
                        const isT3 = stages.includes('T3');
                        const progressT3 = isT3 ? progresses[stages.indexOf('T3')] : 0;

                        let actionButtons = '';
                        const isProgress100 = progresses.includes(100); // If 100% progress exists

                        // If progress is 100, mark as completed and moved to inventory
                        if (isProgress100) {
                            actionButtons = `
                        <span class="badge badge-warning" style="color:#fff;"> Completed Product Moved to Inventory</span>
                    `;
                        } else {
                            // If waiting for manager approval
                            if (row.waiting_for_approval) {
                                actionButtons = `
                            <span class="badge badge-warning">Waiting for Manager Approval Next Synthesis</span>
                        `;
                            }
                            // If at T3 stage and progress < 100, request approval for next steps
                            else if (isT3 && progressT3 < 100 && (row.approval_statuses === null || row.approval_statuses === '')) {
                                actionButtons = `
                            <button class="btn btn-warning" id="request-approval-btn" data-project-id="${row.id}" data-stage-id="${row.t3_stage_id}">
                                Request Manager Approval
                            </button>
                        `;
                            }
                            // If the project has been approved for next steps (manager_approval_status = 3)
                            else if (isT3 && row.approval_statuses == 3) {
                                actionButtons = `
                            <button class="btn btn-success" id="add-stage-btn" data-toggle="modal" data-target="#addStageModal" data-project-id="${row.id}" data-project-name="${row.project_name}" data-stage-val="${isT3}">
                                Add Stages
                            </button>&nbsp;
                            <button class="btn btn-primary view-stage-btn" data-project-id="${row.id}">
                                View Stages
                            </button>
                        `;
                            }
                            // Default condition for "Allocated" status
                            else if (row.allocation_status === 'Allocated') {
                                actionButtons = `
                            <button class="btn btn-success" id="add-stage-btn" data-toggle="modal" data-target="#addStageModal" data-project-id="${row.id}" data-project-name="${row.project_name}" data-isT3-val="${isT3}">
                                Add Stage
                            </button>&nbsp;
                            <button class="btn btn-primary view-stage-btn" data-project-id="${row.id}">
                                View Stages
                            </button>
                        `;
                            }
                        }

                        return actionButtons;
                    }
                }
            ],
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            order: [
                [2, 'desc']
            ]
        });





        $(document).on('click', '.view-stage-btn', function() {
            var projectId = $(this).data('project-id'); // Get project ID from button's data attribute

            // Show the modal to display the stages for this project
            $('#stagesModal').modal('show');

            // Fetch synthesis stages for the selected project
            $.ajax({
                url: `/account/get_synthesis_stages_by_project/${projectId}`, // API endpoint to fetch stages
                method: 'GET',
                success: function(response) {
                    var stagesHtml = ''; // Initialize variable to store HTML for stages

                    // Loop through each stage in the response
                    response.stages.forEach(function(stage) {
                        // Check if SMILES is provided for the stage (optional)
                        var smiles = stage.molecule_structure || ''; // Assuming each stage has a 'smiles' property

                        stagesHtml += `
                    <div class="stage" style="margin-bottom: 20px;">
                        <table class="table table-bordered" style="width: 100%; table-layout: fixed; border-collapse: collapse; font-size: 12px; margin-bottom: 15px;">
                            <thead>
                                <tr style="background-color: #f8f9fa; text-align: center;">
                                    <th style="padding: 8px;">Stage Name</th>
                                    <th style="padding: 8px;">Batch Number</th>
                                    <th style="padding: 8px;">Progress</th>
                                    <th style="padding: 8px;">Reaction</th>
                                    <th style="padding: 8px;">Scale</th>
                                    <th style="padding: 8px;">Experimental Conditions</th>
                                    <th style="padding: 8px;">Results</th>
                                    <th style="padding: 8px;">Yield</th>
                                    <th style="padding: 8px;">Data</th>
                                    <th style="padding: 8px;">Comment</th>
                                    <th style="padding: 8px;">Manager Approval</th>
                                    <th style="padding: 8px;">Approval Comments</th>
                                    <th style="padding: 8px;">Synthesis Scheme</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="text-align: center;">
                                    <td style="padding: 8px;">${stage.stage_name}</td>
                                    <td style="padding: 8px;">${stage.batch_number}</td>
                                    <td style="padding: 8px;">${stage.progress}%</td>
                                    <td style="padding: 8px;">${stage.reaction || 'No reaction provided'}</td>
                                    <td style="padding: 8px;">${stage.scale || 'Not specified'}</td>
                                    <td style="padding: 8px;">${stage.experimental_conditions || 'No conditions specified'}</td>
                                    <td style="padding: 8px;">${stage.results || 'No results provided'}</td>
                                    <td style="padding: 8px;">${stage.yield || 'No yield data'}</td>
                                    <td style="padding: 8px;">${stage.data || 'No data provided'}</td>
                                    <td style="padding: 8px;">${stage.comment || 'No comments'}</td>
                                    <td style="padding: 8px;">${stage.approved ? 'Approved' : 'Not Approved'}</td>
                                    <td style="padding: 8px;">${stage.approval_comments || 'No approval comments'}</td>
                                    <td style="padding: 8px;">
                                        ${stage.molecule_structure || 'No scheme available'}
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        <!-- Display SMILES structure (if available) -->
                        ${smiles ? `
                            <div id="marvin-sketch-${stage.id}" class="marvin-sketch-container" style="margin-top: 20px;height: 500px;">
                                <!-- This div will render the structure -->
                            </div>
                        ` : ''}

                    </div>
                    <hr style="border-top: 1px solid #ccc;">
                `;
                    });

                    // Insert the generated stages HTML into the modal body
                    $('#stagesModalBody').html(stagesHtml);

                    // Now render SMILES structures using MarvinJS
                    response.stages.forEach(function(stage) {
                        var smiles = stage.molecule_structure || ''; // Get SMILES string for this stage
                        if (smiles) {
                            // Create the MarvinJS editor for the SMILES structure
                            ChemicalizeMarvinJs.createEditor(`#marvin-sketch-${stage.id}`).then(function(marvin) {
                                marvin.importStructure('smiles', smiles); // Import the SMILES string
                            });
                        }
                    });
                },
                error: function() {
                    // Handle error, display a message or alert
                    $('#stagesModalBody').html('<p>Error loading stages.</p>');
                }
            });
        });

    }

    // Event delegation for dynamically added "Add Comment" buttons
    $('#project-details-table').on('click', '.add-comment-btn', function() {
        var projectId = $(this).data('project-id');
        // Open the modal
        $('#projectDetailsModal').modal('show');
        // You can use `projectId` here to pass the ID to the modal form, etc.
    });

    $(document).ready(function() {
        // When the "Add Stage" button is clicked
        $('#projectsTableSynthesis').on('click', '#add-stage-btn', function() {
            // Get the project_id from the button's data attribute
            var projectId = $(this).data('project-id');
            var projectName = $(this).data('project-name'); // Assuming project name is passed as data attribute
            var isT3val = $(this).data('stage-val');

            if (isT3val) {
                // Disable the options for T1, T2, and T3
                $('#stage-name option[value="T1"]').prop('disabled', true);
                $('#stage-name option[value="T2"]').prop('disabled', true);
                $('#stage-name option[value="T3"]').prop('disabled', true);

                // Enable options for T4 and T5 (assuming these are the next stages after T3)
                $('#stage-name').append('<option value="T4">T4</option>');
                $('#stage-name').append('<option value="T5">T5</option>');

                $('#stage-name').val('T4'); // Set default to T4
            }
            $('#modal-project-id').val(projectId); // Set the project_id in the read-only field inside the modal

            // Optionally, update the modal title with the project name
            $('#addStageModalLabel').text('Add Stage for ' + projectName); // Update modal title with project name

            // Show the modal
            $('#addStageModal').modal('show');
        });

        $('#addStageForm').on('submit', function(e) {
            e.preventDefault(); // Prevent the default form submission

            // Collect form data from the inputs
            var projectId = $('#modal-project-id').val(); // Get the project ID from the modal input
            var stageName = $('#stage-name').val(); // Get the selected stage name
            var batchNumber = $('#batch-number').val(); // Get the batch number
            var progress = $('#progress').val(); // Get the progress value
            var reaction = $('#reaction').val(); // Get the reaction value
            var scale = $('#scale').val(); // Get the scale value
            var experimentalConditions = $('#experimental-conditions').val(); // Get the experimental conditions value
            var results = $('#results').val(); // Get the results value
            var yieldValue = $('#yield').val(); // Get the yield value
            var data = $('#data').val(); // Get the additional data value

            // Get the molecule structure from Marvin Sketch (SMILES)
            marvinSketcherInstance.exportStructure('smiles').then(function(smiles) {
                if (!smiles || smiles.length === 0) {
                    alert('Please provide a valid molecule structure.');
                    return; // Exit if the SMILES string is empty
                }
                // Send the collected data to the server via AJAX
                $.ajax({
                    url: `/account/add_synthesis_stage/${projectId}`, // Adjust the URL based on your route
                    type: 'POST',
                    data: {
                        project_id: projectId, // Send the project ID
                        stage_name: stageName, // Send the stage name
                        batch_number: batchNumber, // Send the batch number
                        progress: progress, // Send the progress value
                        reaction: reaction, // Send the reaction value
                        scale: scale, // Send the scale value
                        experimental_conditions: experimentalConditions, // Send the experimental conditions
                        results: results, // Send the results value
                        yield: yieldValue, // Send the yield value
                        data: data, // Send the additional data
                        molecule_structure: smiles, // Send the SMILES structure from Marvin Sketch
                        _token: '<?php echo e(csrf_token()); ?>' // CSRF token for security (if using Laravel)
                    },
                    success: function(response) {
                        // Handle success response
                        alert('Stage added successfully!');
                        $('#addStageModal').modal('hide'); // Close the modal
                        loadSynthesisStages(projectId); // Reload the stages (if applicable)
                    },
                    error: function(response) {
                        // Handle error response
                        alert('An error occurred while adding the stage.');
                    }
                });
            }).catch(function(error) {
                console.error('Error exporting SMILES:', error);
                alert('An error occurred while exporting the molecule structure.');
            });
        });


    });

    // Open the modal and populate the fields
    $(document).on('click', '#request-approval-btn', function() {
        var projectId = $(this).data('project-id');
        var stageId = $(this).data('stage-id');

        // Populate the form fields with the respective project and stage information
        $('#projectId').val(projectId);
        $('#stageId').val(stageId);

        // Open the modal
        $('#managerApprovalModal').modal('show');
    });

    // Handle form submission for manager approval
    $('#submit-approval').on('click', function() {
        // Get the values from the modal
        var projectId = $('#projectId').val();
        var stageId = $('#stageId').val();
        var approvalStatus = $('#approval-status').val(); // Get the approval status from the dropdown
        var approvalComments = $('#approval-comments').val(); // Get the comments

        // Send the approval request via AJAX
        $.ajax({
            url: '/account/request_manager_approval',
            type: 'POST',
            data: {
                project_id: projectId,
                stage_id: stageId,
                manager_approval_status: approvalStatus,
                comments: approvalComments,
                _token: $('meta[name="csrf-token"]').attr('content') // CSRF token for protection
            },
            success: function(response) {
                alert(response.message); // Show success message
                $('#managerApprovalModal').modal('hide'); // Close the modal
                location.reload(); // Reload the page to reflect the changes
            },
            error: function(response) {
                alert(response.responseJSON.message); // Show error message
            }
        });
    });


    // Function to load synthesis stages and related data
    function loadSynthesisStages(projectId) {
        $.ajax({
            url: `/account/synthesis/${projectId}`, // Adjust your URL based on the route
            type: 'GET',
            success: function(response) {
                let rows = '';
                let stages = response.stages;
                let comments = response.comments;
                let approvals = response.approvals;

                // Loop through each stage and create the table rows
                stages.forEach(function(stage) {
                    // Get the comment for the current stage
                    let comment = getComment(stage.id, comments);

                    // Get the approval button HTML
                    let approvalButton = getApprovalButton(stage.id, approvals);

                    rows += `
                        <tr>
                            <td>${stage.stage_name}</td>
                            <td>${stage.batch_number}</td>
                            <td>
                                <div class="progress">
                                    <div class="progress-bar" style="width: ${stage.progress}%"></div>
                                </div>
                            </td>
                            <td>
                                <textarea class="form-control" rows="3" readonly>${comment}</textarea>
                                <button class="btn btn-primary btn-sm" onclick="addComment(${stage.id}, ${projectId})">Add Comment</button>

                            </td>
                            <td>
                                ${approvalButton}
                            </td>
                        </tr>
                    `;
                });

                // Update the table with the new rows
                $('#synthesis-stages-table tbody').html(rows);

            },
            error: function(xhr, status, error) {
                alert('An error occurred while loading synthesis data.');
            }
        });
    }

    // $('#add-stage-btn').on('click', function() {
    //     // Get the project_id from the button's data attribute
    //     var projectId = $(this).data('project-id');

    //     // Set the project_id in the modal's input field
    //     $('#modal-project-id').val(projectId); // Set the value in the hidden input field in the modal

    //     // Optionally, you can update the modal header with the project name (if needed)
    //     var projectName = $(this).data('project-name'); // Assuming project name is passed as data attribute
    //     $('#addStageModalLabel').text('Add Stage for ' + projectName); // Update modal title with project name

    //     // Show the modal
    //     $('#addStageModal').modal('show');
    // });

    $('#add-stage-form').on('submit', function(e) {
        e.preventDefault();
        var projectId = $('#modal-project-id').val();
        var stageName = $('#stage-name').val();
        var batchNumber = $('#batch-number').val();
        var progress = $('#progress').val();
        var reaction = $('#reaction').val();
        var scale = $('#scale').val();
        var experimentalConditions = $('#experimental-conditions').val();
        var results = $('#results').val();
        var yieldValue = $('#yield').val();
        var data = $('#data').val();

        $.ajax({
            url: `/account/add_synthesis_stage/${projectId}`,
            type: 'POST',
            data: {
                project_id: projectId,
                stage_name: stageName,
                batch_number: batchNumber,
                progress: progress,
                reaction: reaction,
                scale: scale,
                experimental_conditions: experimentalConditions,
                results: results,
                yield: yieldValue,
                data: data,
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                alert(response.message);
                $('#addStageModal').modal('hide'); // Close the modal
                loadSynthesisStages(projectId); // Reload the stages table
            },
            error: function() {
                alert('Error adding synthesis stage');
            }
        });
    });

    //var projectId;




    $('#submit-comment').on('click', function() {
        var comment = $('#comment-text').val();
        // var stageId = $('#commentModal').data('stage-id');
        var projectId = $('#project_id_val').val();
        if (comment.trim() === '') {
            alert('Please enter a comment.');
            return;
        }

        $.ajax({
            url: `/account/synthesis/${projectId}/stage/${stageId}/comment`,
            type: 'POST',
            data: {
                comment: comment,
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                $('#commentModal').modal('hide');
                alert(response.message);
                loadSynthesisStages(projectId); // Reload stages after adding comment
            }
        });
    });
    // // Add comment to stage
    // function addComment(stageId, projectId) {
    //     var comment = prompt('Enter comment:');
    //     if (comment) {
    //         $.ajax({
    //             url: `/manufacturing_projects/${projectId}/synthesis/comment/${stageId}`,
    //             type: 'POST',
    //             data: {
    //                 comment: comment,
    //                 _token: '<?php echo e(csrf_token()); ?>'
    //             },
    //             success: function(response) {
    //                 alert(response.message);
    //                 loadSynthesisStages(projectId); // Reload the stages after adding a comment
    //             }
    //         });
    //     }
    // }

    // Handle manager approval
    function approveStage(stageId, projectId) {
        var comments = prompt('Enter approval comments:');
        if (comments) {
            $.ajax({
                url: `/manufacturing_projects/${projectId}/synthesis/approve/${stageId}`,
                type: 'POST',
                data: {
                    comments: comments,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    alert(response.message);
                    loadSynthesisStages(projectId); // Reload stages after approval
                }
            });
        }
    }

    // Complete synthesis process
    function completeSynthesis(projectId) {
        $.ajax({
            url: `/manufacturing_projects/${projectId}/synthesis/complete`,
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                alert(response.message);
                location.reload(); // Reload the page after completing the synthesis
            }
        });
    }

    // Check if there's a comment for the stage
    function getComment(stageId, comments) {
        var comment = '';
        comments.forEach(function(item) {
            if (item.stage_id === stageId) {
                comment = item.comment;
            }
        });
        return comment;
    }

    // Return approval button based on the approval status
    function getApprovalButton(stageId, approvals) {
        var approval = approvals.find(function(approval) {
            return approval.stage_id === stageId;
        });
        if (approval && approval.approved) {
            return 'Approved';
        } else {
            return `<button class="btn btn-success btn-sm" onclick="approveStage(${stageId}, ${projectId})">Approve</button>`;
        }
    }

    // Handling the final synthesis process (e.g., "Complete Synthesis")
    $(document).on('click', '#completeSynthesisBtn', function() {
        var projectId = $(this).data('id'); // Get project ID from button
        completeSynthesis(projectId); // Call the complete synthesis function
    });


    function loadDispatchDetails() {
        if ($.fn.dataTable.isDataTable('#dispatchInfoDetails')) {
            // Destroy the existing DataTable instance
            dispatchInfoDetails.clear().destroy();
        }

        var dispatchInfoDetails = $('#dispatchInfoDetails').DataTable({
            processing: false, // Enable processing indicator
            serverSide: true, // Enable server-side processing
            ajax: {
                url: '/account/get_dispatch_details_details', // Your API route
                type: 'GET',
                data: function(d) {
                    // You can pass additional parameters here if needed
                },
                dataSrc: function(json) {
                    return json.data; // This will populate the table with data from 'data'
                }
            },
            columns: [{
                    data: 'id',
                    title: 'ID'
                },
                {
                    data: 'project_id',
                    title: 'Project ID'
                },
                {
                    data: 'dispatch_date',
                    title: 'Dispatch Date'
                },
                {
                    data: 'invoice_number',
                    title: 'Invoice Number'
                },
                {
                    data: 'tracking_number',
                    title: 'Tracking Number'
                },
                {
                    data: 'dispatch_mode',
                    title: 'Dispatch Mode'
                },
                {
                    data: 'dispatch_status',
                    title: 'Dispatch Status',
                    render: function(data, type, row) {
                        let badgeClass = '';
                        let badgeText = '';

                        // Assign badge class and text based on the dispatch_status value
                        switch (data) {
                            case 'Pending':
                                badgeClass = 'badge-secondary';
                                badgeText = 'Pending';
                                break;
                            case 'Shipped':
                                badgeClass = 'badge-info';
                                badgeText = 'Shipped';
                                break;
                            case 'Delivered':
                                badgeClass = 'badge-success';
                                badgeText = 'Delivered';
                                break;
                            case 'Returned':
                                badgeClass = 'badge-danger';
                                badgeText = 'Returned';
                                break;
                            case 'In Transit':
                                badgeClass = 'badge-primary';
                                badgeText = 'In Transit';
                                break;
                            case 'Out for Delivery':
                                badgeClass = 'badge-warning';
                                badgeText = 'Out for Delivery';
                                break;
                            case 'Dispatched to Warehouse':
                                badgeClass = 'badge-info';
                                badgeText = 'Dispatched to Warehouse';
                                break;
                            case 'Canceled':
                                badgeClass = 'badge-dark';
                                badgeText = 'Canceled';
                                break;
                            case 'On Hold':
                                badgeClass = 'badge-warning';
                                badgeText = 'On Hold';
                                break;
                            case 'Ready for Dispatch':
                                badgeClass = 'badge-info';
                                badgeText = 'Ready for Dispatch';
                                break;
                            case 'In Customs':
                                badgeClass = 'badge-primary';
                                badgeText = 'In Customs';
                                break;
                            case 'Shipment Delayed':
                                badgeClass = 'badge-danger';
                                badgeText = 'Shipment Delayed';
                                break;
                            case 'Scheduled for Pickup':
                                badgeClass = 'badge-warning';
                                badgeText = 'Scheduled for Pickup';
                                break;
                            case 'Failed Delivery Attempt':
                                badgeClass = 'badge-danger';
                                badgeText = 'Failed Delivery Attempt';
                                break;
                            case 'Partial Delivery':
                                badgeClass = 'badge-info';
                                badgeText = 'Partial Delivery';
                                break;
                            case 'Returned to Sender':
                                badgeClass = 'badge-danger';
                                badgeText = 'Returned to Sender';
                                break;
                            case 'Delivered to Pickup Point':
                                badgeClass = 'badge-success';
                                badgeText = 'Delivered to Pickup Point';
                                break;
                            case 'Awaiting Customer Confirmation':
                                badgeClass = 'badge-warning';
                                badgeText = 'Awaiting Confirmation';
                                break;
                            case 'Dispatch Failed':
                                badgeClass = 'badge-danger';
                                badgeText = 'Dispatch Failed';
                                break;
                            case 'Dispatched to Third Party':
                                badgeClass = 'badge-info';
                                badgeText = 'Dispatched to Third Party';
                                break;
                            default:
                                badgeClass = 'badge-secondary';
                                badgeText = 'Unknown Status';
                                break;
                        }

                        // Return the badge HTML
                        return `<span class="badge ${badgeClass}">${badgeText}</span>`;
                    }
                },
                {
                    data: 'total_dispatch_weight',
                    title: 'Total Dispatch Weight'
                },
                {
                    data: 'total_dispatch_value',
                    title: 'Total Dispatch Value'
                },
                {
                    data: 'insurance_required',
                    title: 'Insurance Required'
                },
                {
                    data: 'insurance_provider',
                    title: 'Insurance Provider'
                },
                {
                    data: 'dispatch_priority',
                    title: 'Dispatch Priority'
                },
                {
                    data: 'estimated_delivery_date',
                    title: 'Estimated Delivery Date'
                },
                {
                    data: 'proof_of_delivery',
                    title: 'Proof of Delivery'
                },
                {
                    data: 'dispatch_method',
                    title: 'Dispatch Method'
                },
                {
                    data: 'port_of_origin',
                    title: 'Port of Origin'
                },
                {
                    data: 'port_of_destination',
                    title: 'Port of Destination'
                },
                {
                    data: 'dispatch_notes',
                    title: 'Dispatch Notes'
                },
                {
                    data: 'created_at',
                    title: 'Created At'
                },
                {
                    data: 'updated_at',
                    title: 'Updated At'
                }
            ],
            scrollCollapse: true, // Allow the table to collapse
            pageLength: 10, // Set page length (adjust as needed)
            lengthMenu: [10, 25, 50, 100], // Set available page lengths
            drawCallback: function(settings) {
                $('#dispatchInfoDetails_processing').hide();
            },
            initComplete: function(settings, json) {
                // Inline CSS for table header and cell alignment
                $('#dispatchInfoDetails thead th').each(function(index) {
                    // Apply inline CSS for each header element
                    if (index === 7 || index === 8) {
                        // For columns 7 and 8 (e.g., 'total_dispatch_weight' and 'total_dispatch_value')
                        $(this).css('text-align', 'right');
                    } else {
                        $(this).css('text-align', 'center');
                    }
                });

                $('#dispatchInfoDetails tbody td').each(function(index) {
                    // Apply inline CSS for each table cell
                    if (index === 7 || index === 8) {
                        $(this).css('text-align', 'right'); // Right-align columns 7 and 8
                    } else {
                        $(this).css('text-align', 'center'); // Center-align other columns
                    }
                });
            },
            // Disable fixedHeader, as it may conflict with scrollX
            scrollX: true,
            fixedHeader: true,
            autoWidth: false, // Disable automatic column width
            stateSave: true, // Save s
        });
    }


    // $(document).on('click', '#request-approval-btn', function() {
    //     var projectId = $(this).data('project-id');

    //     // Make AJAX call to request manager approval
    //     $.ajax({
    //         url: '/account/request_manager_approval',
    //         type: 'POST',
    //         data: {
    //             project_id: projectId
    //         },
    //         success: function(response) {
    //             alert(response.message); // Display success or error message
    //         },
    //         error: function(xhr, status, error) {
    //             alert('An error occurred: ' + error);
    //         }
    //     });
    // });
</script>
<?php $__env->stopPush(); ?>


<!-- <td>
                               
                                <form class="check-stock-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="${item.id}">
                                    <input type="number" name="quantity" placeholder="Enter quantity" required>
                                    <button type="submit">Check Stock</button>
                                </form>

                              
                                <form class="allocate-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="${item.id}">
                                    <input type="number" name="quantity" placeholder="Quantity to allocate" required>
                                    <button type="submit">Allocate</button>
                                </form>

                              
                                <form class="purchase-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="product_id" value="${item.id}">
                                    <input type="number" name="quantity" placeholder="Quantity to purchase" required>
                                    <button type="submit">Purchase</button>
                                </form>
                            </td> -->
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/krishnareddy/Downloads/script/resources/views/manufacturing/index.blade.php ENDPATH**/ ?>